@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
@include('frontend.layouts.components.booking2.guest')

<!-- section -->
<section class="mb-4">
	<div class="container">

		<ul class="row g-2">
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking2.mypage.qr.index', [
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['signin_code'],
						]) !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-qrcode fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						受付QR
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking2.mypage.datetime.update') !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-pen-to-square fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						予約変更
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="{!! route('frontend.covid.booking2.mypage.booking.destroy') !!}"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-ban fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						キャンセル
					</div>
				</a>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		{{-- nav --}}
		<ul
			class="nav nav-tabs nav-justified mb-3"
			role="tablist"
		>
			<li
				class="nav-item"
				role="presentation"
			>
				<button
					class="nav-link active"
					data-bs-toggle="tab"
					data-bs-target="#tab-0"
					type="button"
					role="tab"
					aria-controls="tab-0"
					aria-selected="true"
				>
					<span class="fw-bold">
						個人情報
					</span>
				</button>
			</li>
			@if ($booking['is_form'])
				<li class="nav-item" role="presentation">
					<button
						class="nav-link"
						data-bs-toggle="tab"
						data-bs-target="#tab-1"
						type="button"
						role="tab"
						aria-controls="tab-1"
						aria-selected="false"
					>
						<span class="fw-bold">
							予診票
						</span>
					</button>
				</li>
			@endif
		</ul>
		{{-- /.nav --}}

		{{-- tab-content --}}
		<div class="tab-content">
			<div
				class="tab-pane fade show active"
				id="tab-0"
				role="tabpanel"
				tabindex="0"
			>
				
				{{-- list-group --}}
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								氏名
							</span>
						</div>
						<div class="ms-auto">
							{!! implode(' ', [
								$booking['patient_sname'],
								$booking['patient_gname'],
							]) !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								氏名（かな）
							</span>
						</div>
						<div class="ms-auto">
							{!! implode(' ', [
								$booking['patient_skana'],
								$booking['patient_gkana'],
							]) !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								生年月日
							</span>
						</div>
						<div class="ms-auto">
							{!! \Carbon\Carbon::create($booking['birthday'])->isoFormat('YYYY年M月D日') !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								性別
							</span>
						</div>
						<div class="ms-auto">
							{!! __("lang.dictionary.gender.{$booking['gender']}") !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								基礎疾患あり
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['is_disease'] ? 'はい' : 'いいえ' !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								携帯電話番号
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['mobile'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								郵便番号
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['zip'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								都道府県
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['pref_label'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								市町村区
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['address1'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								町域
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['address2'] !!}
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								番地・建物名
							</span>
						</div>
						<div class="ms-auto">
							{!! $booking['address3'] !!}
						</div>
					</li>
				</ul>
				{{-- /.list-group --}}

			</div>

			@if ($booking['is_form'])
				<div
					class="tab-pane fade"
					id="tab-1"
					role="tabpanel"
					tabindex="0"
				>
					<ul class="list-group list-group-flush">
						@foreach ($form_list as $key => $value)
							<li class="list-group-item py-3">
								<dl class="mb-0">
									<dt class="mb-2">
										{!! $value['form_label'] !!}
									</dt>
									<dd class="mb-0">
										<ul class="list-unstyled mb-0">
											<li>
												回答 ：
												<span class="fw-normal">
													{!! __("lang.dictionary.is_yesno.{$value['value']}") !!}
												</span>
											</li>
											@if ($value['value'])

												{{-- subform1 --}}
												@if (isset($value['subform1']))
													<li class="mt-1">
														@if ($value['is_input_group1'])
															{!! $value['is_input_group1'] !!}{!! nl2br($value['subform1_label']) !!}
														@else
															{!! nl2br($value['subform1_label']) !!} ：
															<span>
																@if ($value['mtb_form_id'] == 12)
																	{!! \Carbon\Carbon::parse($value['subform1'])->format('Y年n月j日') !!}
																@else
																	{!! $value['subform1'] !!}
																@endif
															</span>
														@endif
													</li>
												@endif

												{{-- subform2 --}}
												@if (isset($value['subform2']))
													<li class="mt-1">
														{!! nl2br($value['subform2_label']) !!} ：
														<span>
															{!! $value['subform2'] !!}
														</span>
													</li>
												@endif

												{{-- subform3 --}}
												@if (isset($value['subform3']))
													<li class="mt-1">
														{!! nl2br($value['subform3_label']) !!} ：
														<span>
															{!! $value['subform3'] !!}
														</span>
													</li>
												@endif

											@endif
										</ul>
									</dd>
								</dl>
							</li>
						@endforeach
					</ul>
				</div>
			@endif
		</div>
		{{-- /.tab-content --}}

	</div>
</section>
<!-- /.section -->

@if ($booking['is_form'])
	<!-- nav -->
	<br><br><br><br>
	<nav class="bar-bottom">
		<div class="d-grid gap-2 w-100">
			<a
				class="btn btn-primary btn-lg"
				href="{!! route('frontend.covid.booking2.pdf.create', [
					$booking['signin_code'],
				]) !!}"
				target="_blank"
			>
				<span class="fw-bold">
					予診票を確認
				</span>
			</a>
		</div>
	</nav>
	<!-- /.nav -->
@endif

<!-- nav -->
{{--<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-3"
			href="{!! route('frontend.covid.booking.mypage.signin.destroy') !!}"
		>
			<span class="fw-bold">
				{!! __("lang.button.signout") !!}
			</span>
		</a>
	</div>
</nav>--}}
<!-- /.nav -->
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
	$(function() {
		//
	});
</script>
@stop
