@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div
			class="alert alert-primary p-4"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				予約の確認・変更
			</h3>
			<hr>

			<p class="mb-0">
				ワクチン予約の確認・変更・キャンセルをご希望の方は、生年月日と携帯電話番号を入力して本人認証してください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if ($errors->any())
			<div class="alert alert-danger mb-3">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="mb-3">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					生年月日（西暦）
				</span>
			</label>
			<div class="input-group input-group-lg mb-0">
				{!! Form::select('birthday[yy]', $date_list['year_list'], 1970,[
					'class' => 'form-select',
				]) !!}
				{!! Form::select('birthday[mm]', $date_list['month_list'], '',[
					'class' => 'form-control text-center',
				]) !!}
				{!! Form::select('birthday[dd]', $date_list['day_list'], '',[
					'class' => 'form-control text-center',
				]) !!}
			</div>
		</div>
		<div class="mb-3">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					携帯電話番号
				</span>
			</label>
			<div class="input-group input-group-lg mb-0">
				{!! Form::tel('mobile', '', [
					'class' => 'form-control',
				]) !!}
			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-primary btn-lg"
			type="submit"
			name="action"
			value="store"
		>
			<span class="fw-bold">
				本人認証する
			</span>
		</button>
		{{-- <a
			class="btn btn-outline-secondary btn-lg border border-secondary border-3"
			href="{!! route('frontend.covid.booking.home.index') !!}"
		>
			<span class="fw-bold text-dark">
				{!! __("lang.button.home") !!}
			</span>
		</a> --}}
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
