@extends('frontend.layouts.main')

{{-- content --}}
@section('content')
@include('frontend.layouts.components.guest')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">
		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
                ワクチン種類
			</h3>
			<hr>
			<p class="fw-bold mb-0">
                接種を希望されるワクチン種類を選択してください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
		<div class="alert alert-danger mb-4">
			<ul class="mb-0 ps-3">
				@foreach ($errors->all() as $error)
					<li>
						{!! $error !!}
					</li>
				@endforeach
			</ul>
		</div>
	@endif
	{{-- /.alert --}}

        <div class="row mb-3">

            <div class="mb-2">
                {!! Form::radio('selected_vaccine_id', '', (is_null(\Session::get('selected_vaccine_id')) ?: false), [
                    'class' => 'btn-check',
                    'id' => "vaccine-unselected",
                    'autocomplete' => 'off',
                ]) !!}
                <label
                    class="btn btn-outline-primary w-100"
                    for="vaccine-unselected"
                >
                    <span class="fs-4 fw-bold">
                        指定なし
                    </span>
                </label>
            </div>
            @foreach($vaccine_list as $key => $value)
                <div class="mb-2">
                    {!! Form::radio('selected_vaccine_id', $key, (is_null(\Session::get('selected_vaccine_id')) ? false : \Session::get('selected_vaccine_id') == $key), [
                        'class' => 'btn-check',
                        'id' => "vaccine{$key}",
                        'autocomplete' => 'off',
                    ]) !!}
                    <label
                        class="btn btn-outline-primary w-100"
                        for="vaccine{!! $key !!}"
                    >
                        <span class="fs-4 fw-bold">
                            {!! $value !!}
                        </span>
                    </label>
                </div>
            @endforeach
        </div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.mypage.edit.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
