@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				生年月日 / 医療・介護従事者
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				生年月日を入力してください。<br>
				医療従事者・介護従事者に該当するか選択してください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-4">
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="section-title d-flex justify-content-center align-items-center mb-3">
			<h3>
				生年月日
			</h3>
			<span class="badge rounded-pill text-bg-danger ms-1">
				{!! __("lang.form.required") !!}
			</span>
		</div>
		<div class="mb-4">
			{{-- <label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					生年月日（西暦）
				</span>
			</label> --}}
			<div class="input-group input-group-lg">
				{!! Form::select('birthday[yy]', $date_list['year_list'], (\Session::get('birthday') === null) ? 1970 : \Session::get('birthday.yy'), [
					'class' => 'form-select',
					'style' => 'width:30%;',
				]) !!}
				{{-- {!! Form::select('birthday[yy]', $date_list['wareki_list'], (\Session::get('birthday') === null) ? 1970 : \Session::get('birthday.yy'), [
					'class' => 'form-select',
					'style' => 'width:30%;',
				]) !!} --}}
				{!! Form::select('birthday[mm]', $date_list['month_list'], (\Session::get('birthday') === null) ? '' : \Session::get('birthday.mm'), [
					'class' => 'form-select',
				]) !!}
				{!! Form::select('birthday[dd]', $date_list['day_list'], (\Session::get('birthday') === null) ? '' : \Session::get('birthday.dd'), [
					'class' => 'form-select',
				]) !!}
			</div>
		</div>

		<div class="section-title d-flex justify-content-center align-items-center mb-3">
			<h3>
				医療・介護従事者ですか？
			</h3>
			<span class="badge rounded-pill text-bg-danger ms-1">
				{!! __("lang.form.required") !!}
			</span>
		</div>
		<div class="mb-3">
			{{-- <label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger">
					{!! __("lang.form.required") !!}
				</span>
				<span class="fw-bold">
					医療従事者・介護従事者ですか？
				</span>
			</label> --}}
			<div
				class="btn-group btn-group-lg d-flex"
				role="group"
			>
				@for($i = 1; $i >= 0; $i--)
					{!! Form::radio('booking[is_staff]', $i, (is_null(\Session::get('booking.is_staff')) ? (($i == 0) ? true : false) : ((\Session::get('booking.is_staff') == $i) ? true : false)), [
						'class' => 'btn-check',
						'id' => "is_staff{$i}",
						'autocomplete' => 'off',
					]) !!}
					<label
						class="btn btn-outline-primary flex-fill"
						for="is_staff{!! $i !!}"
					>
						<span class="fw-bold">
							{!! __("lang.dictionary.is_yesno.{$i}") !!}
						</span>
					</label>
				@endfor
			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.agreement.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
