@extends('frontend.layouts.sticky')

{{-- content --}}
@section('content')
{!! Form::open($form) !!}

<!-- section -->
<section class="mb-4">
	<div class="container">

		@include('frontend.layouts.components.progress')

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				ワクチン種類
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				接種を希望されるワクチン種類を選択してください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		{{-- alert --}}
		@if($errors->any())
			<div class="alert alert-danger mb-4">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					{!! __("lang.error.title") !!}
				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					@foreach ($errors->all() as $error)
						<li>
							{!! $error !!}
						</li>
					@endforeach
				</ul>
			</div>
		@endif
		{{-- /.alert --}}

		<div class="row mb-3">

			@if($vaccine_list_count > 1)
				<div class="mb-2">
					{!! Form::radio('booking[mtb_vaccine_id]', '', (is_null(\Session::get('booking.mtb_vaccine_id')) ? true : false), [
						'class' => 'btn-check',
						'id' => "vaccine-unselected",
						'autocomplete' => 'off',
					]) !!}
					<label
						class="btn btn-outline-primary w-100"
						for="vaccine-unselected"
					>
						<span class="fs-4 fw-bold">
							指定なし
						</span>
					</label>
				</div>
			@endif

			@foreach($vaccine_list as $key => $value)
				<div class="mb-2">
					{{--{!! Form::radio('booking[mtb_vaccine_id]', $value['mtb_vaccine_id'], (is_null(\Session::get('booking.mtb_vaccine_id')) ? true : \Session::get('booking.mtb_vaccine_id') == $value['mtb_vaccine_id']), [
						'class' => 'btn-check',
						'id' => "vaccine{$value['mtb_vaccine_id']}",
						'autocomplete' => 'off',
					]) !!}--}}
                    {!! Form::radio('booking[mtb_vaccine_id]', $value['mtb_vaccine_id'], true, [
						'class' => 'btn-check',
						'id' => "vaccine{$value['mtb_vaccine_id']}",
						'autocomplete' => 'off',
					]) !!}
					<label
						class="btn btn-outline-primary w-100"
						for="vaccine{!! $value['mtb_vaccine_id'] !!}"
					>
						<span class="fs-4 fw-bold">
							{!! $value['vaccine_label'] !!}
						</span>
					</label>
				</div>
			@endforeach
		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						{!! __("lang.button.next") !!}
					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="{!! route('frontend.covid.booking.condition.index') !!}"
				>
					<span class="fw-bold">
						{!! __("lang.button.back") !!}
					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

{!! Form::close() !!}
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {
	//
});
</script>
@stop
