@extends('frontend.layouts.frontdesk')

{{-- content --}}
@section('content')
<div class="row justify-content-center">
	<div class="col col-lg-9">

		<div class="d-flex justify-content-center align-items-center mb-4">
			<span class="fs-2 fw-bold">
				{!! \Carbon\Carbon::create(
					$yy,
					$mm,
					$dd
				)->isoFormat('YYYY年M月D日（ddd）') !!}
			</span>
		</div>

		<div
			class="alert alert-primary mb-4 py-5"
			role="alert"
		>
			<p class="fs-2 fw-bold lh-base">
				マイページより受付QRコードを表示させ、<br>
				QRコードリーダーで読み取ってください。
			</p>
		</div>

		<div class="">
			{!! Form::open($form) !!}
			{!! Form::hidden('yy', $yy) !!}
			{!! Form::hidden('mm', $mm) !!}
			{!! Form::hidden('dd', $dd) !!}
			{!! Form::hidden('is_accepted', 1) !!}

			<div class="input-group input-group-lg">
				{{-- <span class="input-group-text fw-bold bg-white">
					{!! __("lang.booking.voucher_number") !!}
				</span> --}}
				{!! Form::text('voucher_number', '', [
					'class' => 'form-control fs-4',
				]) !!}
				<button
					class="btn btn-primary"
					id=""
					name="action"
					value="store"
					style="width:120px;"
				>
					<span class="fw-bold">
						読み取る
					</span>
				</button>
				<button
					class="btn btn-outline-primary"
					id="reload"
					type="button"
					style="width:120px;"
				>
					<span class="fw-bold">
						再読込
					</span>
				</button>
			</div>

			{!! Form::close() !!}
		</div>

	</div>
</div>
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	// set focus
	$('input:visible').eq(0).focus();

	// submit
	$('input[name="voucher_number"]').keyup(function (e) {
		$('form').submit();
	});

	// click
	$('#reload').on({
		'click': function() {
			location.href = '{!! route('frontend.covid.frontdesk.qr.index') !!}';
		}
	});
});
</script>
@stop
