@extends('frontend.layouts.frontdesk')

{{-- content --}}
@section('content')

<div class="row justify-content-center">
	<div class="col col-lg-9">

		{{-- success --}}
		@if(is_null($error))
			{!! Form::open($form) !!}
			{!! Form::hidden('yy', $yy) !!}
			{!! Form::hidden('mm', $mm) !!}
			{!! Form::hidden('dd', $dd) !!}
			{!! Form::hidden('booking[booking_code]', $booking['booking_code']) !!}

			<div
				class="alert alert-primary mb-4 py-3"
				role="alert"
			>
				<p class="fs-2 fw-bold mb-0">
					下記内容で受け付けます。よろしいですか？
				</p>
			</div>

			<div class="card mb-4">
				<div class="card-body p-4">

					<dl class="row fs-3 mb-4">
						<dt class="col-4 mb-0 text-end">
							予約日時　：
						</dt>
						<dd class="col-8 mb-0 text-start">
							{!! \Carbon\Carbon::create(
								$booking['yy'],
								$booking['mm'],
								$booking['dd'],
								$booking['hh'],
								$booking['ii']
							)->isoFormat('YYYY年M月D日（ddd）HH時mm分') !!}
						</dd>
					</dl>
					<dl class="row fs-3 mb-4">
						<dt class="col-4 mb-0 text-end">
							接種券番号　：
						</dt>
						<dd class="col-8 mb-0 text-start">
							{!! $booking['voucher_number'] !!}
						</dd>
					</dl>
					<dl class="row fs-3 mb-4">
						<dt class="col-4 mb-0 text-end">
							氏名カナ　：
						</dt>
						<dd class="col-8 mb-0 text-start">
							{!! implode('', [
								$booking['patient_skana'],
								$booking['patient_gkana'],
							]) !!}
						</dd>
					</dl>
					<dl class="row fs-3 mb-0">
						<dt class="col-4 mb-0 text-end">
							生年月日　：
						</dt>
						<dd class="col-8 mb-0 text-start">
							{!! \Carbon\Carbon::parse($booking['birthday'])->format(__("lang.date.yymmdd")) !!}
						</dd>
					</dl>

				</div>
			</div>

			<div class="d-grid gap-2">
				<button
					class="btn btn-primary btn-lg"
					type="submit"
					name="action"
					value="checkedin"
				>
					<span class="fs-2 fw-bold">
						はい、間違いありません
					</span>
				</button>
				<a
					class="btn btn-outline-primary btn-lg border border-primary border-3"
					href="{!! route('frontend.covid.frontdesk.qr.index', [
						$yy,
						$mm,
						$dd,
					]) !!}"
				>
					<span class="fs-2 fw-bold">
						QRコード読み取りに戻る
					</span>
				</a>
			</div>

			{!! Form::close() !!}

		{{-- failed --}}
		@else

			{{-- not exist --}}
			@if($error == 100)
				<div
					class="alert alert-danger mb-4 py-5"
					role="alert"
				>
					<p class="fs-2 fw-bold mb-3">
						予約情報が見つかりません。<br>
						予約内容を再確認してください。
					</p>
					<p class="fs-2 fw-bold mb-0">
						3秒後にQRコード読み取りに戻ります。
					</p>
				</div>

				{{-- <div class="d-grid gap-3">
					<a
						class="btn btn-outline-danger btn-lg border border-danger border-3"
						href="{!! route('frontend.covid.frontdesk.qr.index') !!}"
					>
						<span class="fs-2 fw-bold">
							QRコード読み取りに戻る
						</span>
					</a>
				</div> --}}
			@endif

			{{-- already --}}
			@if($error == 200)
				<div
					class="alert alert-warning mb-4 py-5"
					role="alert"
				>
					<p class="fs-2 fw-bold mb-3">
						受け付け済みです。<br>
						問診内容確認ブースへおすすみください。
					</p>
					<p class="fs-2 fw-bold mb-0">
						3秒後にQRコード読み取りに戻ります。
					</p>
				</div>
			@endif

		@endif

	</div>
</div>
@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	@if(!is_null($error))
		setTimeout(function(){
			window.location.href = '{!! route('frontend.covid.frontdesk.qr.index', [
				$yy,
				$mm,
				$dd,
			]) !!}';
		}, (1000 * 3));
	@endif
});
</script>
@stop
