@extends('frontend.layouts.mobile')

{{-- content --}}
@section('content')
<!-- section -->
<section class="mb-5">

	<div class="container">

		<div class=" my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				発熱や風邪症状があるときの<br>対応フローチャート
			</h2>
		</div>

		<div class="text-center">
			<a
				href="{!! implode('/', [
					asset('templates'),
					'mobile',
					'img',
					'guidance',
					'home-img1.jpg',
				]) !!}"
				data-fancybox="images"
				data-caption="発熱外来への受診を考えている方へ"
			>
				<img
					class="img-fluid mb-0"
					src="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img1.jpg',
					]) !!}"

				>
			</a>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">

	{{-- STEP1 --}}
	<div class="section-header text-center mb-3 py-3">
		<h6>
			<div class="mb-2">
				【STEP1】
			</div>
			<div>
				必ず医療機関を受診した方が良い人
			</div>
		</h6>
	</div>

	<div class="container">

		<article class="mb-4">

			<ol class="ps-3">
				<li>
					1. 重症化・死亡リスクの評価
				</li>
				<li>
					新型コロナ感染、あるいはインフルエンザの有無にかかわらずリスクの高い人の2つがあります
				</li>
			</ol>

			<h6 class="mb-2">
				1. 重症化・死亡リスクの高い人
			</h6>
			<div class="mb-3">
				@foreach($q02_list as $key => $value)
					<div class="form-check">
						{!! Form::radio('q02', $key, null, [
							'class' => 'form-check-input',
							'id' => "label{$key}",
							'style' => 'zoom:1.2',
						]) !!}
						<label
							class="form-check-label"
							for="label{!! $key !!}"
						>
							<span class="fw-bold">
								{!! $value !!}
							</span>
						</label>
					</div>
				@endforeach
			</div>

			<div class="d-grid gap-2 mb-4">
				<button
					class="btn btn-outline-secondary"
					type="button"
					data-bs-toggle="modal"
					data-bs-target="#modal-bmi"
				>
					<span class="fw-bold">
						BMIを計算するツール
					</span>
				</button>
				<button
					class="btn btn-primary btn-lg"
					type="button"
					id="btn-severe"
				>
					<span class="fw-bold">
						判定する
					</span>
				</button>
			</div>

			<div class="card mb-3">
				<div class="card-body">
					<dl class="mb-0">
						<dt class="mb-1">
							【診断】
						</dt>
						<dd class="mb-0">
							<span class="fs-5 fw-bold" id="AD"></span>
						</dd>
					</dl>
				</div>
			</div>

			<p class="">
				*ただし、新型コロナウイルスの場合は妊婦であることや、産後2週間以内は、明らかな重症化リスクとはされていません
			</p>

			<dl class="">
				<dt class="">
					注）
				</dt>
				<dd class="mb-0">
					<ol class="ps-3">
						<li>
							ステロイドホルモン、抗リウマチ薬のリウマトレックス（メトトレキサート）、アラバ、プログラフ、あるいは抗がん剤を使っている場合
						</li>
						<li>
							第8波までの死亡率のデータでは70歳以上で急激に上昇しています(下は埼玉県のデータです) 。
							<div class="">
								<img
									class="img-fluid"
									src="{!! implode('/', [
										asset('img'),
										'guidance',
										'main',
										'img1.jpg',
									]) !!}"
								>
							</div>
						</li>
						<li>
							様々な研究からワクチン未接種の方は接種した方より遙かに大きい重症化や死亡のリスクが高いことがわかっています。
						</li>
					</ol>
				</dd>
			</dl>
			
			<h6 class="text-danger">
				ワクチン未接種者は二価ワクチンを接種した人とくらべて、なんと、死亡率がほぼ15倍なのです
			</h6>
			<div class="mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'main',
						'img2.jpg',
					]) !!}"
				>
			</div>

			<dl class="small mb-0">
				<dt  class="">
					(参考)
				</dt>
				<dd class="mb-0">
					<ul class="list-unstyled mb-0">
						<li>
							重症化因子　　<a href="https://www.cov19-vaccine.mhlw.go.jp/qa/uploads/11-19.pdf" target="_blank">厚労省HPに移動</a>
						</li>
						<li>
							年齢別致死率:埼玉県庁公表のデータ　　<a href="https://www.pref.saitama.lg.jp/b0714/surveillance/covid-19.html" target="_blank">埼玉県庁HPに移動</a>
						</li>
					</ul>
				</dd>
			</dl>
		</article>

		<article class="mb-0">
			<h6 class="mb-2">
				2. リスクの高い症状がある人
			</h6>
			<div class="mb-3">
				@foreach($q05_list as $key => $value)
					<div class="form-check">
						{!! Form::radio('q05', $key, null, [
							'class' => 'form-check-input',
							'id' => "label{$key}",
							'style' => 'zoom:1.2',
						]) !!}
						<label
							class="form-check-label"
							for="label{!! $key !!}"
						>
							<span class="fw-bold">
								{!! $value !!}
							</span>
						</label>
						@if($key == 5)
							<ul class="mb-0 ps-3">
								<li>
									のどが痛くてものがのみ込めない
								</li>
								<li>
									口が開けにくい
								</li>
								<li>
									ヨダレが出てくる
								</li>
								<li>
									のどのあたりからゼーゼー音がする
								</li>
								<li>
									声がれがひどい
								</li>
								<li>
									前屈みにならないと息が苦しい
								</li>
							</ul>
						@endif
					</div>
				@endforeach
			</div>
			<div class="d-grid gap-2 mb-3">
				<button
					class="btn btn-primary btn-lg"
					type="button"
					id="btn-serious"
				>
					<span class="fw-bold">
						判定する
					</span>
				</button>
			</div>
			<div class="card mb-3">
				<div class="card-body">
					<dl class="mb-0">
						<dt class="mb-1">
							【診断】
						</dt>
						<dd class="mb-0">
							<span class="fs-5 fw-bold" id="dis"></span>
						</dd>
					</dl>
				</div>
			</div>
			<div class="alert alert-danger text-center mb-3">
				<p class="fw-bold mb-0">
					これらに該当する場合は、新型コロナ感染でなくても、命に関わる重大な病気にかかっている可能性があります。必ずご相談ください。
				</p>
			</div>
			<p class="">
				もう少し詳しく調べたい方は次のツールをご利用ください。
			</p>
			<div class="d-grid gap-2">
				<button
					class="btn btn-danger"
					id="btn-fever"
					type="button"
				>
					<span class="fw-bold">
						おおまかに発熱の原因を診断するツール
					</span>
				</button>
			</div>
		</article>
	</div>

</section>
<!-- /.section -->

<!-- section -->
<section class="mb-0">

	{{-- STEP1 --}}
	<div class="section-header text-center mb-3 py-3">
		<h6>
			<div class="mb-2">
				【STEP2】
			</div>
			<div>
				上記に当てはまらない場合
			</div>
		</h6>
	</div>

	<div class="container">

		<p>
			念のためふたたび確認します。該当する人は重症化予防薬は不要です。
		</p>

		<div class="alert alert-warning mb-3">
			<ul class="fs-5 fw-bold mb-0 ps-3">
				<li>
					70歳以下で
				</li>
				<li>
					重大な基礎疾患がなく
				</li>
				<li>
					危険な症状がなく
				</li>
				<li>
					ワクチンを最低3回は接種している
				</li>
			</ul>
		</div>

		<h6 class="mb-2">
			間違いなければ次のうち、ご自分に一番あうものを選んでください
		</h6>

		<div class="mb-3">
			@foreach($step2_list as $key => $value)
				<div class="form-check">
					{!! Form::radio('step2', $key, ($key == 1) ? true : false, [
						'class' => 'form-check-input',
						'id' => "step2-{$key}",
					]) !!}
					<label
						class="form-check-label"
						for="step2-{!! $key !!}"
					>
						<span class="fs-6 fw-bold">
							{!! $value !!}
						</span>
					</label>
				</div>
			@endforeach
		</div>

		<div class="d-grid gap-2 w-100">
			<button
				type="button"
				id="btn-step2"
				class="btn btn-primary btn-lg"
			>
				<span class="fw-bold">
					判定する
				</span>
			</button>
		</div>

	</div>

</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-outline-secondary btn-lg w-100"
			href="{!! route('frontend.covid.guidance.home.index') !!}"
		>
			<span class="fw-bold">
				戻る
			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->

{{-- modal --}}
<!-- modal-bmi -->
<div
	class="modal fade"
	id="modal-bmi"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					BMIの計算
				</h1>
			</div>
			<div class="modal-body">
				<section class="mb-3">
					<form>
						<div class="alert alert-primary mb-4">
							<div class="d-flex justify-content-start align-items-center">
								<div class="me-auto">
									<h6>
										BMI：
									</h6>
								</div>
								<div>
									<span class="fs-5 fw-bold" id="bmi"></span>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label
								class="col-2 col-form-label fw-bold text-end"
								for=""
							>
								身長
							</label>
							<div class="col">
								<div class="input-group">
									{!! Form::number('q1', '', [
										'class' => 'form-control',
										'id' => 'q1',
										'step' => '1.0'
									]) !!}
									<span class="input-group-text">
										cm
									</span>
								</div>
							</div>
						</div>
						<div class="row mb-4">
							<label
								class="col-2 col-form-label fw-bold text-end"
								for=""
							>
								体重
							</label>
							<div class="col">
								<div class="input-group">
									{!! Form::number('q2', '', [
										'class' => 'form-control',
										'id' => 'q2',
										'step' => '0.1'
									]) !!}
									<span class="input-group-text">
										kg
									</span>
								</div>
							</div>
						</div>
						<div class="d-grid gap-2 w-100">
							<button
								class="btn btn-primary w-100"
								id="btn-bmi"
								type="button"
							>
								<span class="fw-bold">
									計算する
								</span>
							</button>
						</div>
					</form>
				</section>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

<!-- modal-fever -->
<div
	class="modal fade"
	id="modal-fever"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					発熱と他の症状から病気を推定
				</h1>
			</div>
			<div class="modal-body">

				<div class="alert alert-primary">
					<p class="fw-bold mb-0">
						かなり単純化した診断ツールなので結果は参考程度とお考えください
					</p>
				</div>

				@foreach($fever_list as $i => $content)
					<div class="mb-3">
						<h6 class="mb-2">
							{!! $content['label'] !!}
						</h6>
						<div class="">
							@foreach($content['keys'] as $key => $value)
								{!! Form::radio("q" . sprintf('%02d', $i), $content['values'][$key], ($key == 0) ? true : false, [
									'class' => 'btn-check',
									'id' => "q" . sprintf('%02d', $i) . "-{$key}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-1"
									for="q{!! sprintf('%02d', $i) !!}-{!! $key !!}"
								>
									<span class="fw-bold">
										{!! $value !!}
									</span>
								</label>
							@endforeach
						</div>
					</div>
				@endforeach

			</div>
			<div class="modal-footer">
				<button
					class="btn btn-primary px-5"
					id="btn-fever-result"
					type="button"
					data-bs-target="#modal-fever-result"
					data-bs-toggle="modal"
				>
					<span class="fw-bold">
						判定する
					</span>
				</button>
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

<!-- modal-fever-result -->
<div
	class="modal fade"
	id="modal-fever-result"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					推定結果
				</h1>
			</div>
			<div class="modal-body">

				{{-- alert --}}
				<div class="alert alert-warning" role="alert">
					<h6 class="text-center">
						PCR検査必要ありと判定された方へ
					</h6>
					<hr>
					<ul class="ps-3">
						<li>
							検査ご希望の方、ご相談はお近くの医療機関へお問い合わせください。
						</li>
						<li>
							平和台病院では日曜祝日の検査は行っておりません。<br>平日の午前中8時45分から11時30分までの間に下記へご連絡ください。<br>
						</li>
					</ul>
					<p class="fw-bold fs-6 text-center mt-2 mb-0">
						<span class="me-1">
							<i class="fa-solid fa-mobile-screen-button fa-fw fa-lg"></i>	
						</span>
						04-7189-1111　平和台病院
					</p>
				</div>
				{{-- /.alert --}}

				<ul class="list-group list-group-flush">
					<li class="list-group-item px-0">
						<div class="mb-1">
							PCRの必要性
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="PCR"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							新型コロナウイルスを含めた上気道炎
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="COLD"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							敗血症
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="SEPSIS"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							倦怠感の強い発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="FATIGGUE"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							頭痛の強い発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="HEADACKE"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							消化器症状を伴う発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="ABDOMEN"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							関節痛を伴う発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="ARTHRITIS"></span>
						</div>
					</li>
				</ul>

			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

<!-- modal-esteem -->
<div
	class="modal fade"
	id="modal-esteem"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					なぜ、「みなし陽性」の場合は、改めて検査をしないのですか？
				</h1>
			</div>
			<div class="modal-body">

				<p class="">
					おそらく、多くの方が誤解されていると思われるのは、<span class="fs-6 fw-bold text-danger">「PCRや抗原検査が陰性でも、感染していないことの証明にはならない」</span>ということです。
				</p>
				<img
					class="img-fluid mb-3"
					src="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img4.jpeg',
					]) !!}"
				>
				<p class="mb-3">
					なぜ、そうなるかというとほとんど全ての検査は間違いを起こすからです。感染している人をしていないと判定したり、してない人をしていると判定したりします。<br>
					感染している人を正しく「感染している」と判断する割合を「感度」といいます。<br>
					感染していない人を「感染していない」と判断する割合を「特異度」といいます。<br><br>
					新型コロナウイルスの検査の感度・特異度はおおむねこのようになります。
				</p>
				<a
					href="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img5.jpeg',
					]) !!}"
					data-fancybox="images"
					data-caption="発熱外来への受診を考えている方へ"
				>
					<img
						class="img-fluid mb-3"
						src="{!! implode('/', [
							asset('templates'),
							'mobile',
							'img',
							'guidance',
							'home-img5.jpeg',
						]) !!}"
					>
				</a>
				<p class="mb-3">
					特異度はどちらの検査も素晴らしいですが、感度には問題があるのがわかると思います。<br><br>
					実際に感染している10人にPCRをすると7人は陽性となり診断できますが、3人は陰性となり見逃します。
				</p>
				<img
					class="img-fluid mb-3"
					src="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img6.jpeg',
					]) !!}"
				>
				<p class="mb-3">
					一方、感染していない10人にPCRをすると99.9%の確率で全員陰性となります。
				</p>
				<img
					class="img-fluid mb-3"
					src="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img7.jpeg',
					]) !!}"
				>
				<p class="mb-3">
					たとえば、100人中10人が感染している場合に、全員にPCRをかけると、感染していない人はほぼ確実に陰性となりますが、3人の感染が見逃されます。 
				</p>
				<div class="row g-2 mb-3">
					<div class="col">
						<a
							href="{!! implode('/', [
								asset('templates'),
								'mobile',
								'img',
								'guidance',
								'home-img8.jpeg',
							]) !!}"
							data-fancybox="images"
							data-caption="発熱外来への受診を考えている方へ"
						>
							<img
								class="img-fluid mb-3"
								src="{!! implode('/', [
									asset('templates'),
									'mobile',
									'img',
									'guidance',
									'home-img8.jpeg',
								]) !!}"
							>
						</a>
					</div>
					<div class="col">
						<a
							href="{!! implode('/', [
								asset('templates'),
								'mobile',
								'img',
								'guidance',
								'home-img9.jpeg',
							]) !!}"
							data-fancybox="images"
							data-caption="発熱外来への受診を考えている方へ"
						>
							<img
								class="img-fluid mb-3"
								src="{!! implode('/', [
									asset('templates'),
									'mobile',
									'img',
									'guidance',
									'home-img9.jpeg',
								]) !!}"
							>
						</a>
					</div>
				</div>
				<p class="mb-3">
					検査には上記のような限界がありますから、見逃しはやむを得えませんが、この3人という人数をどう思われるでしょうか？<br><br>
					新しい感染の波が来て感染者が増えてくるような時期には、対象者の70%以上が感染者という状況が日常になってきます。<br><br>
					70％が感染しているというのは極端だと思われるかも知れません。しかし、新しい感染の波が来ると発熱外来での検査陽性率は簡単に70％を越えてきます。この70％というのは全人口が対象では無く、「新型コロナ感染が蔓延した状態で、発熱や咳、喉の痛みなどがあって病院に来る人」が対象だからです。基本的に感染が疑われる人しか来ません。<br><br>
					100人中70人が感染している場合に、全員にPCRをかけると、感染していない人はやはりほぼ確実に陰性となります。そして、49人は正しく診断されますが、なんと21人もの感染が見逃されてしまいます。
				</p>
				<img
					class="img-fluid mb-3"
					src="{!! implode('/', [
						asset('templates'),
						'mobile',
						'img',
						'guidance',
						'home-img10.jpeg',
					]) !!}"
				>
				<p class="mb-3">
					100％が感染した集団にPCRを行ったときの検査陽性率が70％ですから、事実上、全員が感染していると想定した方がよいぐらいなのです。<br><br>
					オミクロン株以降の新型コロナウイルスの感染力は非常に高いのです。<br><br>
					感染者との濃厚接触があり、発熱や風邪症状があって発熱外来に来るような方では、検査が陽性に出ればもちろん感染していることになりますが、<span class="fs-6 fw-bold text-danger">検査が陰性になっても検査の感度が不十分なために見逃しているだけである可能性が非常に高い</span>のです。特に同居して衣食住を共にしているような場合は検査が陰性でもまったくあてになりません。<br><br>
					このような場合は、状況証拠が検査の精度を上まわっているのだと言えます。結局、検査をしようがするまいが新型コロナ感染とせざるを得ません。これが、「みなし陽性」とする理由です。そういう人の検査がたまたま陰性になって、注意深い感染対策なしに活発な社会活動を続ければ、ウイルスをばらまくことになるのです。<br><br>
					濃厚接触がなく発熱外来を受診し、検査が陰性になった人では、可能性はやや低くなりますが、それでも新型コロナウイルス感染でないことは証明できません。この場合は、休業して自宅安静とすることが困難でも、最低10日間は、厳格に他人との濃厚接触を避けたほうがよいと思います。
				</p>
				<div class="alert alert-warning mb-3">
					<ul class="list-unstyled fs-6 fw-bold mb-0">
						<li class="mb-2">
							濃厚接触があって10日以内に発熱や咳、鼻水、喉の痛みなどの症状が出たら新型コロナ感染と診断する
						</li>
						<li>
							症状がある場合は検査が陰性でも10日間は他人との濃厚接触を避ける
						</li>
					</ul>
				</div>
				<p class="mb-3">
					注）濃厚接触については<a href="https://www.mhlw.go.jp/stf/houdou_kouhou/kouhou_shuppan/magazine/202109_00005.html" target="_blank">ここを参照</a>ください。
				</p>

			</div>
			<div class="modal-footer">
				<button
					class="btn btn-primary"
					data-bs-target="#modal-step2-3"
					data-bs-toggle="modal"
				>
					判定ページに戻る
				</button>
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>


@for($i = 1; $i <= 4; $i++)
	<!-- modal-step -->
	<div
		class="modal fade"
		id="modal-step2-{!! $i !!}"
		tabindex="-1"
		aria-hidden="true"
	>
		<div class="modal-dialog modal-dialog-scrollable">
			<div class="modal-content">
				<div class="modal-header">
					<h1 class="modal-title fs-5">
						{!! $step2_list[$i] !!}
					</h1>
				</div>
				<div class="modal-body">

					{{-- 1 --}}
					@if($i == 1)
						<section class="mb-5">
							<h6 class="mb-3">
								【STEP1】抗原キットの種類を確認する
							</h6>
							<ul class="mb-3 ps-3">
								<li>
									抗原検査は種類によってかなり信頼性に差があります。
								</li>
								<li>
									信頼性が高く厚生労働省に認可されているのは以下の抗原検査です。
								</li>
							</ul>
							<div class="d-grid gap-2">
								<a
									class="btn btn-outline-secondary"
									href="https://www.mhlw.go.jp/stf/newpage_27779.html"
									target="_blank"
								>
									<span class="fw-bold">
										厚労省が認可している抗原検査キット
									</span>
								</a>
							</div>
						</section>

						<section class="mb-5">
							<h6 class="mb-3">
								【STEP2】検査結果を確認する
							</h6>
							<dl class="mb-4">
								<dt class="fs-6 mb-2">
									陽性の場合
								</dt>
								<dd>
									<ul class="mb-2 ps-3">
										<li>
											「新型コロナ感染」と確定診断されます。
										</li>
										<li>
											病院に行って再検査する必要はありません。
										</li>
										<li>
											症状を和らげる内服薬を希望する場合のみ受診してください。ただし、市販薬も病院で処方する薬も風邪症状に対しての効果はさほど変わりません。
										</li>
									</ul>
									<div class="alert alert-danger mb-0">
										<span class="fw-bold">
											ただし、前項の「必ず医療機関を受診した方が良い人」に該当する場合は必ず受診ください。
										</span>
									</div>
								</dd>
							</dl>
							<dl class="mb-0">
								<dt class="fs-6 mb-2">
									陰性の場合
								</dt>
								<dd>
									<div class="alert alert-warning mb-2">
										<span class="fw-bold">
											新型コロナウイルスに感染していないことの証明にはなりません。
										</span>
									</div>
									<ul class="mb-0 ps-3">
										<li>
											可能であれば、5日間休業して自宅安静とするのが無難です。
										</li>
										<li>
											できなくても10日間は濃厚接触を避ける。
										</li>
										<li>
											以上が一般的な対応ですが、具体的には職場でご相談ください。
										</li>
									</ul>
								</dd>
							</dl>
						</section>
					@endif

					{{-- 2 --}}
					@if($i == 2)
						<section class="mb-5">
							<h6 class="mb-3">
								病院に行く意味
							</h6>
							<ol class="mb-3 ps-3">
								<li class="mb-1">
									<span class="fw-bold">症化リスクが高い場合</span>　⇒　重症化予防薬の処方を検討します。
								</li>
								<li class="mb-2">
									<span class="fw-bold">すごく具合が悪い</span>　⇒　重症新型コロナ感染に限らずよく調べて治療します。
								</li>
								<li class="mb-2">
									<span class="fw-bold">重症ではないが薬が欲しい</span>　⇒　調剤薬局での処方（薬が貰えるまで3-4時間はかかります）
								</li>
								<li>
									<span class="fw-bold">休業のために診断書を書いて欲しい</span>　⇒　検査をして診断書を書きますが時間はかかります（陰性証明は書けません）
								</li>
							</ol>
							<p class="mb-3">
								風邪症状の緩和については病院で貰う薬も、市販薬もあまり効果は変わりません。市販薬でも医療用と同等の成分が含まれているものもあります
							</p>
							<div class="alert alert-danger mb-0">
								<span class="fw-bold">
									1. 2. に該当する場合ははじめに戻ってください。どちらの場合も医療機関にかかる必要があります。
								</span>
							</div>
						</section>
					@endif

					{{-- 3 --}}
					@if($i == 3)
						<section class="mb-5">
							<h6 class="mb-3">
								【STEP1】本当に濃厚接触したか確認する
							</h6>
							<dl class="mb-3">
								<dt class="fs-6 mb-2">
									濃厚接触
								</dt>
								<dd>
									<p class="">
										感染者の発症あるいは検査陽性の2日前から11日までに次に該当する接触があった場合
									</p>
									<ul class="mb-0 ps-3">
										<li>
											陽性者と同居している人
										</li>
										<li>
											陽性者と長時間接触した人(車内、航空機内などを含む。機内は国際線では陽性者の前後2列以内の列に搭乗して いた人、国内線では周囲2m以内に搭乗していた人が原則)
										</li>
										<li>
											適切な感染防護なしに患者(確定例)を診察、看護もしくは介護していた人
										</li>
										<li>
											陽性者の気道分泌液や体液などの汚染物質に直接触れた可能性が高い人
										</li>
										<li>
											マスクなしで陽性者と1m以内で15分以上接触があった人
										</li>
									</ul>
								</dd>
							</dl>
						</section>

						<section class="mb-0">
							<h6 class="mb-3">
								【STEP2】濃厚接触があった場合
							</h6>
							<dl class="mb-3">
								<dt class="fs-6 mb-2">
									症状がある場合
								</dt>
								<dd>
									<div class="alert alert-danger mb-3">
										<span class="fw-bold">
											濃厚接触したあとに症状が出れば、原則的に「みなし陽性」として新型コロナ感染症と診断されます
										</span>
									</div>
									<ul class="mb-3 ps-3">
										<li>
											病院に受診しても、それ以上の検査は行わずに「新型コロナ感染」と診断します。
										</li>
										<li>
											必要があれば重症化予防薬を処方しますが、基本的には症状を和らげる薬だけです。これは基本的には薬局の薬と効果は変わりません。
										</li>
										<li>
											要であれば診断書は発行します。
										</li>
										<li>
											活動の自粛については検査で陽性と診断された人と全く同じです。
										</li>
									</ul>
									<div class="d-grid gap-2">
										<button
											class="btn btn-danger btn-sm"
											type="button"
											data-bs-target="#modal-esteem"
											data-bs-toggle="modal"
										>
											<span class="fw-bold">
												検査をしないで「みなし陽性」と診断する理由
											</span>
										</button>
									</div>
								</dd>
							</dl>
							<dl class="mb-3">
								<dt class="fs-6 mb-2">
									症状がない場合
								</dt>
								<dd>
									<ul class="mb-0 ps-3">
										<li>
											症状が無いと病院に来ても検査は受けられません。来院しても基本的には無駄になります。
										</li>
										<li>
											無症状の濃厚接触者に対する、定められた行動制限の基準はありません。
										</li>
										<li>
											検査をしないのであれば感染が診断された方と同様の行動制限をするのが無難だと思います（強制ではありません）。<br>
											以下に5類移行前の厚生労働省の指針と、アメリカの指針をご紹介します
										</li>
									</ul>
									<div class="alert alert-warning mb-3">
										<h6 class="alert-heading fs-6">
											感染者と濃厚接触（厚生労働省：5類移行前）
										</h6>
										<hr>
										<p class="fw-bold mb-0">
											最終日を0日として2日後に検査<br>
											陰性なら、さらに3日目に検査<br>
											全て陰性なら解除
										</p>
									</div>
									<div class="alert alert-warning">
										<h6 class="alert-heading fs-6">
											感染者と濃厚接触（アメリカ）
										</h6>
										<hr>
										<p class="fw-bold mb-0">
											すぐに抗原検査<br>
											48時間後、2回目の抗原検査<br>
											96時間後、3回目の抗原検査<br>
											全て、陰性なら「感染していない」と判断する
										</p>
									</div>
								</dd>
							</dl>
							<dl class="mb-0">
								<dt class="fs-6 mb-2">
									感染者行動制限の原則
								</dt>
								<dd>
									<div class="alert alert-danger">
										<h6 class="alert-heading mb-3">
											初めて症状が出た日、あるいは症状が無い場合は診断日を0日目とする
										</h6>
										<ul class="fw-bold mb-0 ps-3">
											<li>
												はじめの1〜5日は自宅で安静とする
											</li>
											<li>
												6〜10日は他人との濃厚接触を厳密に避ける
											</li>
										</ul>
									</div>
								</dd>
							</dl>
						</section>
					@endif

					{{-- 4 --}}
					@if($i == 4)
						<section class="mb-0">
							<p class="mb-3">
								新型コロナウイルスは5類に変更されたので、重症化の心配がほとんどなく、症状もさほど強くない場合は、病院に行かず、外出も控えず普段どおりに暮らしても法律違反にはなりません。<br><br>
								しかし、その場合でも他人に感染させることだけは、十分に注意して避けてください。感染が広がれば、抵抗力の強い人だけではなく、ご高齢だったり、重い基礎疾患を持つ方々も必ず巻き込まれます。そうすると一定の確率で亡くなる方が出てくるのです。
							</p>
							<ul class="fw-bold text-danger mb-3 ps-4">
								<li class="mb-2">
									発熱や、せき、喉の痛みなどの症状があっても、病院にも行かない、検査もしないというのであれば、新型コロナウイルスに感染したことを想定して行動してください。
								</li>
								<li>
									検査をして感染が証明できなければ休業は難しいかも知れませんが、発症日を0日として、10日間は他人との濃厚接触を絶対に避けてください。もちろん、外食も控えてください。
								</li>
							</ul>
							<p class="mb-3">
								また、なるべく病院に行かずに済ませるには、
							</p>
							<ol class="mb-3 ps-4">
								<li>
									普段から、信頼のできる抗原キットを準備しておく
								</li>
								<li>
									薬局で、熱冷まし、咳止めなどの対症療法の薬を買っておく
								</li>
							</ol>
							<p class="mb-3">
								などの準備があればより安心だと思います。
							</p>
							<div class="d-grid gap-2 mt-2">
								<a
									class="btn btn-outline-secondary"
									href="https://www.mhlw.go.jp/stf/newpage_27779.html"
									target="_blank"
								>
									<span class="fw-bold">
										厚生労働省が認可している抗原検査キット
									</span>
								</a>
							</div>
						</section>
					@endif
				</div>
				<div class="modal-footer">
					<button
						class="btn btn-secondary"
						type="button"
						data-bs-dismiss="modal"
					>
						<span class="fw-bold">
							閉じる
						</span>
					</button>
				</div>
			</div>
		</div>
	</div>
	<!-- /.modal -->
@endfor

@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('#btn-bmi').on('click', function() {

		const q1 = $('#q1').val();
		const q2 = $('#q2').val();

		let bmi = q2 / q1 / q1 * 10000
		bmi = bmi.toFixed(2);

		$('#bmi').text(bmi);
	});

	$('#btn-fever').on('click', function() {

		const feverModal = new bootstrap.Modal($('#modal-fever'));
		feverModal.show();
	});

	$('#btn-fever-result').on('click', function() {

		const arrone = $('input:radio[name="q01"]');
		const arrtwo = $('input:radio[name="q02"]');
		const arrthree = $('input:radio[name="q03"]');
		const arrfour = $('input:radio[name="q04"]');
		const arrfive = $('input:radio[name="q05"]');
		const arrseven = $('input:radio[name="q07"]');
		const arreight = $('input:radio[name="q08"]');
		const arrnine = $('input:radio[name="q09"]');
		const arrten = $('input:radio[name="q10"]');

		let fever = 0;
		let nasal = 0;
		let throat = 0;
		let cough = 0;

		if(arrone[1].checked || arrone[2].checked) { fever = 1; }
		if(arrtwo[1].checked || arrtwo[2].checked) { nasal = 1; }
		if(arrthree[1].checked || arrthree[2].checked) { throat = 1; }
		if(arrfour[1].checked || arrfour[2].checked) { cough = 1; }

		let cold = nasal + throat + cough;
		//alert(cold);return false;

		let colddx = "";
		let pcrdx = "";
		let sepsisdx = "";
		let fatiguedx = "";
		let headeckedx = "";
		let arthritisdx = "";
		let rashdx = "";

		if(cold === 0) {
			colddx = "可能性低い";
		} else if(cold === 1 || cold === 2) {
			colddx = "可能性あり";
		} else if(cold === 3) {
			colddx = "可能性高い";
		}
		//alert(colddx);return false;
		
		if(cold + fever === 0) {
			pcrdx = "状況に応じて検討";
		} else {
			pcrdx = "必要あり";
		}
		//alert(pcrdx);return false;
		
		if(fever === 1 && arrfive[2].checked) {
			sepsisdx = "可能性あり。尿路感染や胆嚢・胆管炎を考慮";
		} else if(fever === 1 && arrfive[3].checked) {
			sepsisdx = "可能性高い。尿路感染や胆嚢・胆管炎を考慮";
		} else {
			sepsisdx = "";
		}
		//alert(sepsisdx);return false;
		
		if(fever === 1 && arrseven[2].checked) {
			fatiguedx = "急性肝炎や急性心筋炎、伝染性単核球症などを考慮。鑑別診断は多い";
		} else {
			fatiguedx = "";
		}
		//alert(fatiguedx);return false;
		
		if(fever === 1 && arreight[2].checked) {
			headeckedx = "細菌性髄膜炎を考慮し、腰椎穿刺を検討";
		} else {
			headeckedx = "";
		}
		//alert(headeckedx);return false;
		
		if(fever === 1 && arrnine[1].checked) {
			abddx = "心筋梗塞や小脳梗塞も鑑別する";
		} else if(fever === 1 && arrnine[2].checked) {
			abddx = "急性胃腸炎の可能性が高い";
		} else if(fever === 1 && arrnine[3].checked) {
			abddx = "虫垂炎や憩室炎に注意";
		} else {
			abddx = "";
		}
		//alert(abddx);return false;
		
		if(fever === 1 && cold > 0 && arrten[1].checked) {
			arthritisdx = "パルボウイルス等の感染を考える";
		} else if(fever === 1 && cold === 0 && arrten[1].checked) {
			arthritisdx = "結晶性関節炎等を検討";
		} else{
			arthritisdx = "";
		}
		//alert(arthritisdx);return false;

		$('#COLD').text(colddx);
		$('#PCR').text(pcrdx);
		$('#SEPSIS').text(sepsisdx);
		$('#FATIGGUE').text(fatiguedx);
		$('#HEADACKE').text(headeckedx);
		$('#ABDOMEN').text(abddx);
		$('#ARTHRITIS').text(arthritisdx);
	});

	$('#btn-step2').on('click', function() {

		const id = $('input:radio[name="step2"]:checked').val();
		//alert(id);

		const step2Modal = new bootstrap.Modal($(`#modal-step2-${id}`));
		step2Modal.show();
	});

	// severe
	$('#btn-severe').on('click', function() {
		
		const secondques = $('input:radio[name="q02"]');

		let ad = '';
	
		if(secondques[0].checked || secondques[1].checked || secondques[2].checked || secondques[3].checked || secondques[4].checked || secondques[5].checked || secondques[6].checked || secondques[7].checked) {
			ad = '重症化の可能性が否定できません。医療機関を受診してください';
		}
		else if(secondques[8].checked) {
			ad = '';
		}
		
		$('#AD').text(ad);
	});

	// serious
	$('#btn-serious').on('click', function() {

		const fifthques = $('input:radio[name="q05"]');
		let dis = '';

		if(fifthques[0].checked){dis = "脱水状態になる可能性が高いです";}else if(fifthques[1].checked||fifthques[2].checked){dis = "呼吸状態が悪く肺炎などの可能性があります。重症の新型コロナ感染症の可能性もあります";}else if(fifthques[3].checked){dis = "尿路感染症や胆嚢炎など他の感染症の可能性があります";}else if(fifthques[4].checked){dis = "敗血症など重症の感染症の可能性があります";}
		else if(fifthques[5].checked){dis = "のどの重症感染症を起こしている可能性があります";}
		else if(fifthques[6].checked){dis = "髄膜炎や脳炎を起こしている可能性があります";}
		
		$('#dis').text(dis);
	});
});
</script>
@stop
