@extends('frontend.layouts.mobile')

{{-- content --}}
@section('content')

{{-- page1 --}}
@if($page_id == 1)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				重症化リスク
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				新型コロナウイルスの場合
			</h5>
		</div>

		<div class="container mb-0">

			<p class="mb-0">
				新型コロナウイルス感染症と診断された人のうち重症化しやすいのは、①高齢者と②基礎疾患のある方、③新型コロナウイルスワクチンを未接種、あるいは接種回数が2回以下の方、④一部の妊娠後期の方です。
			</p>

		</div>
	</section>
	<!-- /.section -->

	<!-- section -->
	<section class="mb-5">
		<div class="container mb-0">

			<article class="mb-5">
				<h6 class="mb-3">
					①
					高齢者
				</h6>
				<p class="">
					60歳以上になると新型コロナウイルス感染の重症化リスクや死亡リスクが上がります。個人差はありますが、免疫力が低下するためです。しかし、新型コロウイルスのワクチン接種により、重症化率や死亡率が大きく低下することが示されています。
				</p>
				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="button"
						data-bs-toggle="modal"
						data-bs-target="#modal1"
					>
						<span class="fw-bold">
							年代別重症化率・死亡率
						</span>
					</button>
				</div>
			</article>

			<article class="mb-5">
				<h6 class="mb-3">
					②
					重症化のリスクとなる基礎疾患等は、
				</h6>
				<dl class="">
					<dt class="mb-2">
						（パキロビッド）
					</dt>
					<dd class="">
						<ul class="ps-3">
							<li>
								60歳以上
							</li>
							<li>
								喫煙者（過去30日以内の喫煙があり、かつ障害に100本以上の喫煙がある）
							</li>
							<li>
								免疫抑制疾患または免疫抑制罪の継続投与
							</li>
							<li>
								慢性閉塞性肺疾患(COPD):喘息は処方薬の連日投与を必要とする場合のみ
							</li>
							<li>
								慢性腎臓病
							</li>
							<li>
								糖尿病
							</li>
							<li>
								高血圧
							</li>
							<li>
								心血管疾患:心筋梗塞、脳卒中、一過性脳虚血発作、心不全、ニトログリセリンが処方された狭心症、冠動脈バイパス術後、経皮的冠動脈形成術、頸動脈内膜は切り術亦は大動脈バイパス術の既往を有する
							</li>
							<li>
								肥満（BMI>25）
							</li>
							<li>
								神経発達障害(脳性麻痺、ダウン症候群)または医学的複雑性を付与するその他の疾患(遺伝性疾患、メタボリックシンドローム、重度の先天性異常等)
							</li>
							<li>
								限局性皮膚癌を除く活動性の癌
							</li>
							<li>
								医療技術への依存(SARS-Cob-2による感染症と無関係な持続陽圧呼吸療法等)等
							</li>
						</ul>
						があります。
					</dd>
				</dl>

				<dl class="">
					<dt class="mb-2">
						（ラゲブリオ）
					</dt>
					<dd class="">
						<ul class="ps-3">
							<li>
								61歳以上
							</li>
							<li>
								活動性の癌（免疫抑制または高い死亡率を伴わない癌はのぞく） 　慢性閉塞性肺疾患(COPD)
							</li>
							<li>
								慢性腎臓病
							</li>
							<li>
								肥満（BMI≧30）
							</li>
							<li>
								重篤な心疾患(心不全、冠動脈疾患または心筋症) 　糖尿病
							</li>
							<li>
								ダウン症
							</li>
							<li>
								脳神経疾患(多発性硬化症、ハンチントン病、重症筋無力症等) 　コントロール不良のHIV感染症およびAIDS
							</li>
							<li>
								肝硬変等の重度の肝臓疾患
							</li>
							<li>
								臓器移植後、骨髄移植、幹細胞移植後など
							</li>
						</ul>
						<div class="text-center mb-0">
							<img
								class="img-fluid"
								src="{!! implode('/', [
									asset('img'),
									'guidance',
									'qa',
									'page1-2.jpg',
								]) !!}"
							>
						</div>
					</dd>
				</dl>

				<dl class="">
					<dt class="mb-2">
						（ゾコーバ）
					</dt>
					<dd class="">
						<p class="mb-2">
							基礎疾患がなくても用いることができる
						</p>
						<div class="d-grid gap-2">
							<button
								class="btn btn-primary"
								type="button"
								data-bs-toggle="modal"
								data-bs-target="#modal-bmi"
							>
								<span class="fw-bold">
									BMIの計算
								</span>
							</button>
						</div>
					</dd>
				</dl>
				
			</article>

			<article class="mb-5">
				<h6 class="mb-3">
					③
					ワクチン未接種、あるいは2回以下の人
				</h6>
				<p class="">
					様々な研究からワクチン未接種の方は接種した方より遙かに大きい重症化や死亡のリスクが高いことがわかっています。ワクチン未接種者は二価ワクチンを接種した人とくらべて、なんと、死亡率がほぼ15倍なのです。
				</p>
				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page1-1.jpg',
						]) !!}"
					>
				</div>
				<p class="mb-2">
					このように、ワクチン接種を受けると、重症化の予防が期待できます。逆に言えば、ワクチン接種を受けないことは大きなリスクなのです。<br>
					しかしながら、「ワクチン接種回数2回以下」はパキロビッドの処方条件である「重症化因子」には含まれていないのです。
				</p>
				<p class="fw-bold text-danger mb-0">
					したがって、非常に残念なことながら60歳未満で上記の基礎疾患を持たない場合は、ワクチン未接種であってもパキロビッドの処方は受けられません
				</p>

			</article>

			<article class="mb-0">
				<h6 class="mb-3">
					④
					一部の妊娠後期の方
				</h6>
				<p class="mb-0">
					高齢（35歳以上）、肥満（BMIで30以上）、喫煙、高血圧・糖尿病・喘息などの基礎疾患を持つ妊婦では重症化のリスクが高いことが報告されており注意が必要です。
				</p>

			</article>

		</div>
	</section>
	<!-- /.section -->

	<!-- section -->
	<section class="mb-3">
		<div class="container mb-0">
			<div class="card mb-0">
				<div class="card-body">
					<dl class="mb-0">
						<dt class="">
							文献
						</dt>
						<dd class="small">
							<ol class="mb-0 ps-3">
								<li>
									厚生労働省「(2023年4月版) 新型コロナウイルス感染症の“いま”に関する11の知識」<br>
									<a href="https://www.mhlw.go.jp/content/000927280.pdf" target="_blank">
										https://www.mhlw.go.jp/content/000927280.pdf
									</a>
								</li>
							</ol>
						</dd>
					</dl>
				</div>
			</div>
		</div>
	</section>
	<!-- /.section -->
@endif

{{-- page2 --}}
@if($page_id == 2)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				重症化リスク
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				インフルエンザの場合
			</h5>
		</div>
		
		<div class="container mb-0">

			<article class="mb-0">
				<ol class="fs-6 mb-3">
					<li class="mb-1">
						5歳未満の小児:特に2歳以下の乳幼児が高リスク
					</li>
					<li class="mb-1">
						65歳以上の成人
					</li>
					<li class="mb-1">
						妊婦、産後2週間以内
					</li>
					<li class="mb-1">
						基礎疾患を有するもの
						<ul class="mb-0 ps-3">
							<li>
								慢性呼吸器疾患:喘息, COPD, 嚢胞性線維症など
							</li>
							<li>
								慢性心疾患:高血圧症のみは除く
							</li>
							<li>
								慢性腎疾患、慢性肝疾患、血液疾患、慢性神経筋疾患
							</li>
							<li>
								神経発達異常:脳卒中, てんかん, 精神発達遅延, 脊髄損傷など
							</li>
						</ul>
					</li>
					<li class="mb-1">
						糖尿病を含む代謝異常
					</li>
					<li class="mb-1">
						免疫抑制状態にあるもの:免疫抑制薬投与中
					</li>
					<li class="mb-1">
						治療の必要な癌がある人
					</li>
					<li class="mb-1">
						HIV感染者
					</li>
					<li class="mb-1">
						19歳未満で長期にアスピリンを内服しているもの
					</li>
					<li class="mb-1">
						著明な肥満(BMI≧40)
					</li>
					<li class="mb-1">
						介護老人施設もしくは長期療養施設に入所しているもの
					</li>
				</ol>

				<div class="">
					<span class="small">
						米国感染症学会「季節性インフルエンザの臨床ガイドライン」より
					</span>
				</div>
			</article>
		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page3 --}}
@if($page_id == 3)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				治療薬
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				新型コロナウイルスの場合
			</h5>
		</div>
		
		<div class="container mb-0">

			<ul class="mb-5 ps-3">
				<li class="mb-1">
					ベクルリー（レムデシビル:注射薬）、パキロビッド（ニルマトレルビル/リトナビル:内服薬）、ラゲブリオ（モルヌピラビル:内服薬）、ゾコーバ（エンシトレルビル:内服薬）の4種があります。
				</li>
				<li class="mb-1">
					このうち重症化予防効果が認められているのはベクルリー、パキロビッド、ラゲブリオですが、重症化効果はベクルリー=パキロビッド>>ラゲブリオ>>ゾコーバとなります。
				</li>
			</ul>

			<article class="mb-5">
				<h6 class="mb-2">
					ベクルリー
				</h6>
				<ul class="mb-0 ps-3">
					<li class="mb-1">
						注射薬であり、原則的には入院していなければ使えません
					</li>
					<li class="mb-1">
						初期の臨床試験では重症化を87％減少させたと報告されています
					</li>
					<li class="mb-1">
						高度の腎機能障害がある場合は使えません
					</li>
				</ul>
			</article>

			<article class="mb-5">
				<h6 class="mb-2">
					パキロビッド
				</h6>
				<ul class="mb-3 ps-3">
					<li class="mb-1">
						内服薬なので外来でも使えます
					</li>
					<li class="mb-1">
						初期の臨床試験では重症化を89％減少させたと報告されています
					</li>
					<li class="mb-1">
						重症化徴候も重症化リスクもない場合には使うことができません
					</li>
					<li class="mb-1">
						他に内服している薬の種類によっては、併用することが禁止されていたり、慎重に用いなければならない場合があります
					</li>
					<li class="mb-1">
						高度の腎機能障害がある場合は使えません。このため、処方に先立って血液検査をさせていただく場合があります
					</li>
					<li class="mb-1">
						65歳未満で、重症化徴候がなく、重症化リスクがない方では処方できません
					</li>
				</ul>
				<div class="d-grid gap-2 mb-0">
					<a
						class="btn btn-primary"
						href="{!! route('frontend.covid.guidance.qa.index', [
							1,
						]) !!}"
					>
						<span class="fw-bold">
							重症化リスク
						</span>
					</a>
				</div>
			</article>

			<article class="mb-5">
				<h6 class="mb-2">
					ラゲブリオ
				</h6>
				<ul class="mb-3 ps-3">
					<li class="mb-1">
						内服薬なので外来でも使えます
					</li>
					<li class="mb-1">
						初期の臨床試験では重症化を30％減少させたと報告されています
					</li>
					<li class="mb-1">
						特に、すでにワクチン接種を行った方では、重症化予防効果はほとんど発揮されないという報告があります（*2）。このため、フランスやオーストラリアでは使用が廃止される方向に進んでいます
					</li>
					<li class="mb-1">
						腎機能に関わらず使うことができるので、高度の腎機能障害がある場合によく用いられます
					</li>
					<li class="mb-1">
						妊婦では使用できません
					</li>
				</ul>
				<div class="d-grid gap-2 mb-0">
					<a
						class="btn btn-primary"
						href="{!! route('frontend.covid.guidance.qa.index', [
							1,
						]) !!}"
					>
						<span class="fw-bold">
							重症化リスク
						</span>
					</a>
				</div>
			</article>

			<article class="mb-5">
				<h6 class="mb-2">
					ゾコーバ
				</h6>
				<ul class="mb-0 ps-3">
					<li class="mb-1">
						内服薬なので外来でも使えます
					</li>
					<li class="mb-1">
						重症化や死亡の予防効果はありません
					</li>
					<li class="mb-1">
						症状の回復までの期間を1日だけ短縮します
					</li>
					<li class="mb-1">
						腎機能に関わらず使うことができますが、併用禁止の薬が多いので確認が必要です
					</li>
				</ul>
				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page3-1.jpg',
						]) !!}"
					>
				</div>
			</article>

			<article>
				<div class="card mb-0">
					<div class="card-body pb-2">
						<dl class="small mb-0">
							<dt class="">
								文献
							</dt>
							<dd class="">
								<ol class="mb-0 ps-3">
									<li class="mb-1">
										診療の手引き編集委員会「新型コロナウイルス感染症 COVID-19 診療の手引き 第10.0版」2023/8/21<br>
										<a href="https://www.mhlw.go.jp/content/001136687.pdf" target="_blank">
											https://www.mhlw.go.jp/content/001136687.pdf
										</a>
									</li>
									<li class="mb-1">
										Christopher C Butler他　Molnupiravir plus usual care versus usual care alone as early treatment for adults with COVID-19 at increased risk of adverse outcomes (PANORAMIC): an open-label, platform-adaptive randomised controlled trial　Lancet VOLUME 401, ISSUE 10373, P281-293<br>
										<a href="https://www.thelancet.com/journals/lancet/article/PIIS0140-6736(22)02597-1/fulltext#%20" target="_blank">
											https://www.thelancet.com/journals/lancet/article/PIIS0140-6736(22)02597-1/fulltext#%20
										</a>
									</li>
								</ol>
							</dd>
						</dl>
					</div>
				</div>
			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page4 --}}
@if($page_id == 4)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				治療薬
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				インフルエンザの場合
			</h5>
		</div>
		
		<div class="container mb-0">

			<ul class="mb-5 ps-3">
				<li class="mb-1">
					インフルエンザに罹患しても、とくに合併症リスクを持たない患者は自然に治癒します。だから、必ずしも内服しなくてもよいですが、発症2日以内に抗ウイルス薬を内服すると発熱期間が、平均で1〜2日発熱する期間が減少する可能性があります（通常は平均5日）
				</li>
				<li class="mb-1">
					合併症リスクを持つ患者では2日以内、できるだけ早期に抗ウイルス薬を内服したほうがよいです
				</li>
				<li class="mb-1">
					必要に応じて、解熱剤、痛み止め、咳止めなどの薬を内服してください
				</li>
			</ul>

			<article class="mb-5">
				<h6 class="mb-2">
					効果
				</h6>
				<dl class="">
					<dt class="">
						合併症リスクを持たない患者）
					</dt>
					<dd class="">
						<ul class="mb-0 ps-3">
							<li class="mb-1">
								発症から48時間以内に用いると、発熱期間が1〜2日短縮されます（解熱までの期間は平均5日程度）
							</li>
							<li class="mb-1">
								48時間以上経過すると十分な効果は期待できません
							</li>
						</ul>
					</dd>
				</dl>
				<dl class="mb-0">
					<dt class="">
						合併症リスクを持つ患者）
					</dt>
					<dd class="">
						<ul class="mb-0 ps-3">
							<li class="mb-1">
								抗ウイルス薬を内服すると、入院率、致死率が下がり、ウイルス排出期間を短かくなります
							</li>
						</ul>
					</dd>
				</dl>
			</article>

			<article class="mb-5">
				<h6 class="mb-2">
					インフルエンザ合併症のリスクが高い患者
				</h6>
				<ol class="mb-0">
					<li class="mb-1">
						5歳未満の小児:特に2歳以下の乳幼児が高リスク
					</li>
					<li class="mb-1">
						65歳以上の成人
					</li>
					<li class="mb-1">
						妊婦、産後2週間以内
					</li>
					<li class="mb-1">
						基礎疾患を有するもの
					</li>
					<li class="mb-1">
						糖尿病を含む代謝異常
					</li>
					<li class="mb-1">
						免疫抑制状態にあるもの:免疫抑制薬投与中
					</li>
					<li class="mb-1">
						治療の必要な癌がある人
					</li>
					<li class="mb-1">
						HIV感染者
					</li>
					<li class="mb-1">
						19歳未満で長期にアスピリンを内服しているもの
					</li>
					<li class="mb-1">
						著明な肥満(BMI≧40)
					</li>
					<li class="mb-1">
						介護老人施設もしくは長期療養施設に入所しているもの
					</li>
				</ol>
				<p class="">
					<span class="small">
						米国感染症学会「季節性インフルエンザの臨床ガイドライン」より
					</span>
				</p>
				<div class="text-center mb-0">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page4-1.jpg',
						]) !!}"
					>
				</div>
			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page5 --}}
@if($page_id == 5)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				療養
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				新型コロナウイルスの療養期間
			</h5>
		</div>
		
		<div class="container mb-0">

			<ul class="mb-5 ps-3">
				<li class="mb-1">
					2023年5月の5類移行後は法律で決められた基準はなく、基本的に個人や事業所の判断に任されています
				</li>
				<li class="mb-1">
					一般的に行われているのは以下の指針です
				</li>
			</ul>

			<div
				class="alert alert-warning mb-5"
				role="alert"
			>
				<h6 class="alert-heading mb-3">
					初めて症状が出た日、あるいは症状が無い場合は診療日を0とする
				</h6>
				<ul class="fw-bold fs-6 mb-0 ps-3">
					<li class="mb-1">
						はじめての1〜5日は自宅で安静とする
					</li>
					<li class="mb-1">
						6〜10日は他人との濃厚接触を厳密に避ける
					</li>
				</ul>
			</div>

			<article class="mb-5">
				<h6 class="mb-2">
					療養期間の考え方
				</h6>
				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page5-1.jpg',
						]) !!}"
					>
				</div>
				<p class="fw-bold">
					*症状軽快とは解熱剤を使用せず解熱し、かつ呼吸器症状が改善傾向にあることです。
				</p>

				<div class="d-grid gap-2 mb-3">
					<a
						class="btn btn-primary"
						href=""
					>
						<span class="fw-bold">
							濃厚接触とは？
						</span>
					</a>
				</div>

				<ul class="mb-3 ps-3">
					<li class="mb-1">
						「5日間」という期間は、発症後5日で感染者から排出されるウイルス量がかなり減るからです
					</li>
					<li class="mb-1">
						しかしながら、10日までは感染性のあるウイルスが放出される可能性があるので、他人にうつさないために「濃厚接触を避ける」ことが必要です
					</li>
					<li class="mb-1">
						ワクチン接種により、感染性ウイルスの排出量および期間を短縮することが可能です
					</li>
				</ul>

				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page5-2.jpg',
						]) !!}"
					>
				</div>

			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page6 --}}
@if($page_id == 6)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				療養
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				インフルエンザの療養期間
			</h5>
		</div>
		
		<div class="container mb-0">

			<ul class="mb-5 ps-3">
				<li class="mb-1">
					学童では「発症日を0日として、5日以上経過し、かつ解熱した後2日（用事では3日）以上経過するまでは出席停止（学校保健法）」
				</li>
				<li class="mb-1">
					成人については法律では規定されていませんが、同様の対応をする場合が一般的です
				</li>
			</ul>

			<article class="mb-5">
				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page6-1.jpg',
						]) !!}"
					>
				</div>
			</article>

			<article class="mb-5">
				<h6 class="mb-2">
					注意
				</h6>
				<ul class="mb-0 ps-3">
					<li class="mb-1">
						小児や未成年者では、インフルエンザにかかると、異常行動を起こすことがあります
					</li>
					<li class="mb-1">
						「急に走り出す」、「部屋から飛び出す」、「無目的に歩き回る」などの行動が見られ、危険な場合もあります
					</li>
					<li class="mb-1">
						そのため、少なくともはじめの2日間は、衣が1人にならないように配慮する必要があります
					</li>
				</ul>
			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page7 --}}
@if($page_id == 7)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				療養
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				療養時に気をつけるべきこと
			</h5>
		</div>
		
		<div class="container mb-0">

			<article class="mb-5">
				<h6 class="mb-2">
					1. 危険な症状に気をつける
				</h6>
				<div
					class="alert alert-warning"
					role="alert"
				>
					<span class="fw-bold">
						ほとんどの患者さんは新型コロナウイルスに感染しても数日間の発熱や風邪症状で済みます。しかし、まれには新型コロナ肺炎を起こして重症化したり、あるいは別の最近による感染などを起こすことがあります。
					</span>
				</div>
				<p class="fs-6 fw-bold text-danger">
					特に、以下のような症状がある場合は、新型コロナ感染でなくても、重大な病気にかかっている可能性があります。必ず医療機関でご相談ください。
				</p>

				<div class="mb-3">
					@foreach($q05_list as $key => $value)
						<div class="form-check">
							{!! Form::radio('q05', $key, null, [
								'class' => 'form-check-input',
								'id' => "label{$key}",
								'style' => 'zoom:1.2',
							]) !!}
							<label
								class="form-check-label"
								for="label{!! $key !!}"
							>
								<span class="fw-bold">
									{!! $value !!}
								</span>
							</label>
							@if($key == 5)
								<ul class="mb-0 ps-3">
									<li>
										のどが痛くてものがのみ込めない
									</li>
									<li>
										口が開けにくい
									</li>
									<li>
										ヨダレが出てくる
									</li>
									<li>
										のどのあたりからゼーゼー音がする
									</li>
									<li>
										声がれがひどい
									</li>
									<li>
										前屈みにならないと息が苦しい
									</li>
								</ul>
							@endif
						</div>
					@endforeach
				</div>
				<div class="d-grid gap-2 mb-3">
					<button
						class="btn btn-secondary"
						type="button"
						id="q05"
					>
						<span class="fw-bold">
							あてはまる症状をチェックして判定
						</span>
					</button>
				</div>
				<div class="card mb-3">
					<div class="card-body">
						<dl class="mb-0">
							<dt class="mb-1">
								【診断】
							</dt>
							<dd class="mb-0">
								<span class="fs-5 fw-bold" id="dis"></span>
							</dd>
						</dl>
					</div>
				</div>
				<p class="">
					もう少し詳しく調べたい方は次のツールをご利用ください
				</p>
				<div class="d-grid gap-2 mb-0">
					<button
						class="btn btn-danger btn-lg"
						id="btn-fever"
						type="button"
					>
						<span class="small fw-bold">
							おおまかに発熱の原因を診断するツール
						</span>
					</button>
				</div>
			</article>

			<article class="mb-0">
				<h6 class="mb-2">
					2. 他の人にうつさないようにする
				</h6>
				<p class="fs-6 fw-bold text-danger">
					基本的な感染対策を守ってください
				</p>
				<ul class="mb-0 ps-3">
					<li class="mb-1">
						マスクを外した状態で他人と会話したり、食事をとったりしない
					</li>
					<li class="mb-1">
						マスクを着けていても狭い部屋で長時間会話しないようにする
					</li>
					<li class="mb-1">
						できるだけ、窓などをあけて換気をよくする
					</li>
					<li class="mb-1">
						可能な限り、他人との距離を1m以上あける
					</li>
					<li class="mb-1">
						しっかり手洗いをする
					</li>
				</ul>
			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page8 --}}
@if($page_id == 8)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				その他
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				5類になったけどまだ危ないのですか？
			</h5>
		</div>
		
		<div class="container mb-0">

			<h6 class="mb-3">
				新型コロナ感染症の重症化率と死亡率
			</h6>
			<ul class="mb-3 ps-3">
				<li class="mb-1">
					ワクチン接種の普及とウイルス自体の弱毒化によって重症化率、死亡率とも大幅に下がっています
				</li>
				<li class="mb-1">
					しかし、60〜70歳代では0.18％、80歳代以上では1.69%の死亡率があり、90歳代以上になると2.6％と40人に1人以上が亡くなっています
				</li>
				<li class="mb-1">
					したがって、重症化予防薬を飲むべきなのは、基本的には60歳以上だと考えられます
				</li>
				<li class="mb-1">
					50歳代以下では重症化率0.03%、死亡率0.00％です。しかし、非常に低い確率とはいえ、30〜50歳代でも10000人の感染者のうち1〜2人は亡くなっています
				</li>
			</ul>

			<article class="mb-5">
				<div class="text-center mb-3">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page8-1.jpg',
						]) !!}"
					>
				</div>
				<p class="">
					<span class="small">
						＊石川県、茨城県、広島県のデータを用いて厚生労働省が産出した資料を利用
					</span>
				</p>
				<ul class="mb-5 ps-3">
					<li class="mb-1">
						年齢が上がっていくにつれ重症化率も死亡率も上がっています
					</li>
					<li class="mb-1">
						しかも、年齢とともに、重症化した場合の死亡率も高くなり、90歳以上ではなんと95.6％です
					</li>
					<li class="mb-1">
						この統計では、ワクチン接種の有無、回数、基礎疾患の有無と種類による違いは分かりません
					</li>
					<li class="mb-1">
						しかし、ワクチン未接種で重篤な基礎疾患があれば、重症化率も死亡率ももっと高くなると思われます
					</li>
				</ul>
			</article>

			<article>
				<div class="card mb-0">
					<div class="card-body pb-2">
						<dl class="small mb-0">
							<dt class="">
								文献
							</dt>
							<dd class="">
								<ol class="mb-0 ps-3">
									<li class="mb-1">
										厚生労働省「(2023年4月版) 新型コロナウイルス感染症の“いま”に関する11の知識」<br>
										<a href="https://www.mhlw.go.jp/content/000927280.pdf" target="_blank">
											https://www.mhlw.go.jp/content/000927280.pdf
										</a>
									</li>
								</ol>
							</dd>
						</dl>
					</div>
				</div>
			</article>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- page9 --}}
@if($page_id == 9)
	<!-- section -->
	<section class="mb-5">

		<div class="my-3">
			<h2 class="lh-base text-center mb-0" style="color:#084298;">
				その他
			</h2>
		</div>

		<div class="section-header text-center mb-3 py-3">
			<h5>
				「みなし陽性」って何ですか？
			</h5>
		</div>
		
		<div class="container mb-0">
			
			<h6 class="mb-3">
				なぜ、「みなし陽性」の場合は、改めて検査をしないのですか？
			</h6>
			<p class="">
				おそらく、多くの方が誤解されていると思われるのは、<br>
				<span class="fs-6 fw-bold text-danger">
					「PCRや抗原検査が陰性でも、感染していないことの証明にはならない」
				</span><br>
				ということです。
			</p>
			<div class="text-center mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'qa',
						'page9-1.jpg',
					]) !!}"
				>
			</div>
			<p class="">
				なぜ、そうなるかというとほとんど全ての検査は間違いを起こすからです。感染している人をしていないと判定したり、してない人をしていると判定したりします。<br>
				感染している人を正しく「感染している」と判断する割合を「感度」といいます。<br>
				感染していない人を「感染していない」と判断する割合を「特異度」といいます。
			</p>
			<p class="">
				新型コロナウイルスの検査の感度・特異度はおおむねこのようになります。
			</p>
			<div class="text-center mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'qa',
						'page9-2.jpg',
					]) !!}"
				>
			</div>
			<p class="">
				特異度はどちらの検査も素晴らしいですが、感度には問題があるのがわかると思います。
			</p>
			<p class="">
				実際に感染している10人にPCRをすると7人は陽性となり診断できますが、3人は陰性となり見逃します。
			</p>
			<div class="text-center mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'qa',
						'page9-3.jpg',
					]) !!}"
				>
			</div>
			<p class="">
				一方、感染していない10人にPCRをすると99.9%の確率で全員陰性となります。
			</p>
			<div class="text-center mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'qa',
						'page9-4.jpg',
					]) !!}"
				>
			</div>
			<p class="">
				たとえば、100人中10人が感染している場合に、全員にPCRをかけると、感染していない人はほぼ確実に陰性となりますが、3人の感染が見逃されます。 
			</p>
			<div class="row row-cols-1 row-cols-lg-2 g-3 mb-3">
				<div class="col text-lg-end">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page9-7.jpg',
						]) !!}"
					>
				</div>
				<div class="col text-lg-start">
					<img
						class="img-fluid"
						src="{!! implode('/', [
							asset('img'),
							'guidance',
							'qa',
							'page9-5.jpg',
						]) !!}"
					>
				</div>
			</div>
			<p class="">
				検査には上記のような限界がありますから、見逃しはやむを得えませんが、この3人という人数をどう思われるでしょうか？<br><br>
				新しい感染の波が来て感染者が増えてくるような時期には、対象者の70%以上が感染者という状況が日常になってきます。<br><br>
				70％が感染しているというのは極端だと思われるかも知れません。しかし、新しい感染の波が来ると発熱外来での検査陽性率は簡単に70％を越えてきます。この70％というのは全人口が対象では無く、「新型コロナ感染が蔓延した状態で、発熱や咳、喉の痛みなどがあって病院に来る人」が対象だからです。基本的に感染が疑われる人しか来ません。<br><br>
				100人中70人が感染している場合に、全員にPCRをかけると、感染していない人はやはりほぼ確実に陰性となります。そして、49人は正しく診断されますが、なんと21人もの感染が見逃されてしまいます。
			</p>
			<div class="text-center mb-3">
				<img
					class="img-fluid"
					src="{!! implode('/', [
						asset('img'),
						'guidance',
						'qa',
						'page9-6.jpg',
					]) !!}"
				>
			</div>
			<p class="">
				100％が感染した集団にPCRを行ったときの検査陽性率が70％ですから、事実上、全員が感染していると想定した方がよいぐらいなのです。<br><br>
				オミクロン株以降の新型コロナウイルスの感染力は非常に高いのです。<br><br>
				感染者との濃厚接触があり、発熱や風邪症状があって発熱外来に来るような方では、検査が陽性に出ればもちろん感染していることになりますが、<span class="fs-6 fw-bold text-danger">検査が陰性になっても検査の感度が不十分なために見逃しているだけである可能性が非常に高い</span>のです。特に同居して衣食住を共にしているような場合は検査が陰性でもまったくあてになりません。<br><br>
				このような場合は、状況証拠が検査の精度を上まわっているのだと言えます。結局、検査をしようがするまいが新型コロナ感染とせざるを得ません。これが、「みなし陽性」とする理由です。そういう人の検査がたまたま陰性になって、注意深い感染対策なしに活発な社会活動を続ければ、ウイルスをばらまくことになるのです。<br><br>
				濃厚接触がなく発熱外来を受診し、検査が陰性になった人では、可能性はやや低くなりますが、それでも新型コロナウイルス感染でないことは証明できません。この場合は、休業して自宅安静とすることが困難でも、最低10日間は、厳格に他人との濃厚接触を避けたほうがよいと思います。
			</p>
			<div
				class="alert alert-warning"
				role="alert"
			>
				<p class="fs-6 fw-bold mb-0">
					濃厚接触があって10日以内に発熱や咳、鼻水、喉の痛みなどの症状が出たら新型コロナ感染とする<br><br>
					症状がある場合は検査が陰性でも10日間は他人との濃厚接触を避ける
				</p>
			</div>
			<p class="mb-0">
				<span class="small">
					注）濃厚接触についてはここを参照ください。
				</span>
			</p>

		</div>
	</section>
	<!-- /.section -->

@endif

{{-- nav --}}
<nav class="bar-bottom">
	<div class="flex-grow-1 me-2">
		<a
			class="btn btn-outline-secondary btn-lg w-100"
			href="{!! route('frontend.covid.guidance.home.index') !!}"
		>
			<span class="fw-bold">
				戻る
			</span>
		</a>
	</div>
	<div>
		<button
			class="btn btn-outline-secondary btn-lg"
			type="button"
			data-bs-toggle="offcanvas"
			data-bs-target="#offcanvas"
		>
			<i class="fa-solid fa-bars fa-fw"></i>
		</button>
	</div>
</nav>

{{-- offcanvas --}}
<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvas">
	<div class="offcanvas-header">
		<h6 class="offcanvas-title">
			発熱外来への受診を考えている方へ
		</h6>
		<button
			class="btn-close"
			type="button"
			data-bs-dismiss="offcanvas"
			aria-label="閉じる"
		></button>
	</div>
	<div class="offcanvas-body">
		<div>

			<dl class="mb-4">
				<dt class="mb-2">
					メインページ
				</dt>
				<dd class="">
					<ul class="list-unstyled">
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.home.index', [
									1,
								]) !!}"
							>
								HOME
							</a>
						</li>
					</ul>
				</dd>
			</dl>

			<dl class="mb-4">
				<dt class="mb-2">
					重症化リスク
				</dt>
				<dd class="">
					<ul class="list-unstyled">
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									1,
								]) !!}"
							>
								新型コロナウイルスの場合
							</a>
						</li>
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									2,
								]) !!}"
							>
								インフルエンザの場合
							</a>
						</li>
					</ul>
				</dd>
			</dl>
			<dl class="mb-4">
				<dt class="mb-2">
					治療薬
				</dt>
				<dd class="">
					<ul class="list-unstyled">
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									3,
								]) !!}"
							>
								新型コロナウイルスの場合
							</a>
						</li>
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									4,
								]) !!}"
							>
								インフルエンザの場合
							</a>
						</li>
					</ul>
				</dd>
			</dl>
			<dl class="mb-4">
				<dt class="mb-2">
					療養
				</dt>
				<dd class="">
					<ul class="list-unstyled">
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									5,
								]) !!}"
							>
								新型コロナウイルスの療養期間
							</a>
						</li>
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									6,
								]) !!}"
							>
								インフルエンザの療養期間
							</a>
						</li>
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									7,
								]) !!}"
							>
								療養中はどんなことに注意したらよいですか
							</a>
						</li>
					</ul>
				</dd>
			</dl>
			<dl class="mb-4">
				<dt class="mb-2">
					その他
				</dt>
				<dd class="">
					<ul class="list-unstyled">
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									8,
								]) !!}"
							>
								5類になったけど、まだ危ないのですか？
							</a>
						</li>
						<li>
							<a
								class="text-dark"
								href="{!! route('frontend.covid.guidance.qa.index', [
									9,
								]) !!}"
							>
								「みなし陽性」って何ですか？
							</a>
						</li>
					</ul>
				</dd>
			</dl>

		</div>
	</div>
</div>

{{-- modal1 --}}
<div
	class="modal fade"
	id="modal1"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					新型コロナ感染症の重症化率と死亡率
				</h1>
			</div>
			<div class="modal-body">
				<section class="mb-0">
					<ul class="ps-3">
						<li>
							ワクチン接種の普及とウイルス自体の弱毒化によって重症化率、死亡率とも大幅に下がっています。
						</li>
						<li>
							しかし、60〜70歳代では0.18％、80歳代以上では1.69%の死亡率があり、90歳代以上になると2.6％と40人に1人以上が亡くなっています。
						</li>
						<li>
							したがって、重症化予防薬を飲むべきなのは、基本的には60歳以上だと考えられます。
						</li>
						<li>
							50歳代以下では重症化率0.03%、死亡率0.00％です。しかし、非常に低い確率とはいえ、30〜50歳代でも10000人の感染者のうち1〜2人は亡くなっています。
						</li>
					</ul>
					<div class="mb-3">
						<img
							class="img-fluid"
							src="{!! implode('/', [
								asset('img'),
								'guidance',
								'modal',
								'img1.jpg',
							]) !!}"
						>
					</div>
					<p class="small">
						＊石川県、茨城県、広島県のデータを用いて厚生労働省が産出した資料を利用
					</p>
					<ul class="ps-3 mb-3">
						<li>
							年齢が上がっていくにつれ重症化率も死亡率も上がっています。
						</li>
						<li>
							しかも、年齢とともに、重症化した場合の死亡率も高くなり、90歳以上ではなんと95.6％です。
						</li>
						<li>
							この統計では、ワクチン接種の有無、回数、基礎疾患の有無と種類による違いは分かりません。
						</li>
						<li>
							しかし、ワクチン未接種で重篤な基礎疾患があれば、重症化率も死亡率ももっと高くなると思われます。
						</li>
					</ul>
					<div class="card mb-0">
						<div class="card-body">
							<dl class="mb-0">
								<dt class="small mb-2">
									文献
								</dt>
								<dd class="small mb-0">
									<ol class="ps-3 mb-0">
										<li>
											厚生労働省「(2023年4月版) 新型コロナウイルス感染症の“いま”に関する11の知識」<br>
											<a href="https://www.mhlw.go.jp/content/000927280.pdf" target="_blank">
												https://www.mhlw.go.jp/content/000927280.pdf
											</a>
										</li>
									</ol>
								</dd>
							</dl>
						</div>
					</div>
				</section>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

{{-- modal-bmi --}}
<div
	class="modal fade"
	id="modal-bmi"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					BMIの計算
				</h1>
			</div>
			<div class="modal-body">
				<section class="mb-3">
					<form>
						<div class="alert alert-primary mb-4">
							<div class="d-flex justify-content-start align-items-center">
								<div class="me-auto">
									<h6>
										BMI：
									</h6>
								</div>
								<div>
									<span class="fs-5 fw-bold" id="bmi"></span>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label
								class="col-2 col-form-label fw-bold text-end"
								for=""
							>
								身長
							</label>
							<div class="col">
								<div class="input-group">
									{!! Form::number('q1', '', [
										'class' => 'form-control',
										'id' => 'q1',
										'step' => '1.0'
									]) !!}
									<span class="input-group-text">
										cm
									</span>
								</div>
							</div>
						</div>
						<div class="row mb-4">
							<label
								class="col-2 col-form-label fw-bold text-end"
								for=""
							>
								体重
							</label>
							<div class="col">
								<div class="input-group">
									{!! Form::number('q2', '', [
										'class' => 'form-control',
										'id' => 'q2',
										'step' => '0.1'
									]) !!}
									<span class="input-group-text">
										kg
									</span>
								</div>
							</div>
						</div>
						<div class="d-grid gap-2 w-100">
							<button
								class="btn btn-primary w-100"
								id="btn-bmi"
								type="button"
							>
								<span class="fw-bold">
									計算する
								</span>
							</button>
						</div>
					</form>
				</section>
			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

<!-- modal-fever -->
<div
	class="modal fade"
	id="modal-fever"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					発熱と他の症状から病気を推定
				</h1>
			</div>
			<div class="modal-body">

				<div class="alert alert-primary">
					<p class="fw-bold mb-0">
						かなり単純化した診断ツールなので結果は参考程度とお考えください
					</p>
				</div>

				@foreach($fever_list as $i => $content)
					<div class="mb-3">
						<h6 class="mb-2">
							{!! $content['label'] !!}
						</h6>
						<div class="">
							@foreach($content['keys'] as $key => $value)
								{!! Form::radio("q" . sprintf('%02d', $i), $content['values'][$key], ($key == 0) ? true : false, [
									'class' => 'btn-check',
									'id' => "q" . sprintf('%02d', $i) . "-{$key}",
									'autocomplete' => 'off',
								]) !!}
								<label
									class="btn btn-outline-primary mb-1"
									for="q{!! sprintf('%02d', $i) !!}-{!! $key !!}"
								>
									<span class="fw-bold">
										{!! $value !!}
									</span>
								</label>
							@endforeach
						</div>
					</div>
				@endforeach

			</div>
			<div class="modal-footer">
				<button
					class="btn btn-primary px-5"
					id="btn-fever-result"
					type="button"
					data-bs-target="#modal-fever-result"
					data-bs-toggle="modal"
				>
					<span class="fw-bold">
						判定する
					</span>
				</button>
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

<!-- modal-fever-result -->
<div
	class="modal fade"
	id="modal-fever-result"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-scrollable">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					推定結果
				</h1>
			</div>
			<div class="modal-body">

				{{-- alert --}}
				<div class="alert alert-warning" role="alert">
					<h6 class="text-center">
						PCR検査必要ありと判定された方へ
					</h6>
					<hr>
					<ul class="ps-3">
						<li>
							検査ご希望の方、ご相談はお近くの医療機関へお問い合わせください。
						</li>
						<li>
							平和台病院では日曜祝日の検査は行っておりません。<br>平日の午前中8時45分から11時30分までの間に下記へご連絡ください。<br>
						</li>
					</ul>
					<p class="fw-bold fs-6 text-center mt-2 mb-0">
						<span class="me-1">
							<i class="fa-solid fa-mobile-screen-button fa-fw fa-lg"></i>	
						</span>
						04-7189-1111　平和台病院
					</p>
				</div>
				{{-- /.alert --}}

				<ul class="list-group list-group-flush">
					<li class="list-group-item px-0">
						<div class="mb-1">
							PCRの必要性
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="PCR"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							新型コロナウイルスを含めた上気道炎
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="COLD"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							敗血症
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="SEPSIS"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							倦怠感の強い発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="FATIGGUE"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							頭痛の強い発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="HEADACKE"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							消化器症状を伴う発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="ABDOMEN"></span>
						</div>
					</li>
					<li class="list-group-item px-0">
						<div class="mb-1">
							関節痛を伴う発熱
						</div>
						<div class="">
							<span class="fs-6 fw-bold text-danger" id="ARTHRITIS"></span>
						</div>
					</li>
				</ul>

			</div>
			<div class="modal-footer">
				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						閉じる
					</span>
				</button>
			</div>
		</div>
	</div>
</div>

@endsection

{{-- css --}}
@section('css')
<style>

</style>
@stop

{{-- js --}}
@section('js')
<script>
$(function() {

	$('#q05').on('click', function() {
		
		const fifthques = $('input:radio[name="q05"]');
		let dis = '';

		if(fifthques[0].checked){dis = "脱水状態になる可能性が高いです";}else if(fifthques[1].checked||fifthques[2].checked){dis = "呼吸状態が悪く肺炎などの可能性があります。重症の新型コロナ感染症の可能性もあります";}else if(fifthques[3].checked){dis = "尿路感染症や胆嚢炎など他の感染症の可能性があります";}else if(fifthques[4].checked){dis = "敗血症など重症の感染症の可能性があります";}
		else if(fifthques[5].checked){dis = "のどの重症感染症を起こしている可能性があります";}
		else if(fifthques[6].checked){dis = "髄膜炎や脳炎を起こしている可能性があります";}
		
		$('#dis').text(dis);
	});

	$('#btn-bmi').on('click', function() {

		const q1 = $('#q1').val();
		const q2 = $('#q2').val();

		let bmi = q2 / q1 / q1 * 10000
		bmi = bmi.toFixed(2);

		$('#bmi').text(bmi);
	});

	$('#btn-fever').on('click', function() {

		const feverModal = new bootstrap.Modal($('#modal-fever'));
		feverModal.show();
	});

	$('#btn-fever-result').on('click', function() {

		const arrone = $('input:radio[name="q01"]');
		const arrtwo = $('input:radio[name="q02"]');
		const arrthree = $('input:radio[name="q03"]');
		const arrfour = $('input:radio[name="q04"]');
		const arrfive = $('input:radio[name="q05"]');
		const arrseven = $('input:radio[name="q07"]');
		const arreight = $('input:radio[name="q08"]');
		const arrnine = $('input:radio[name="q09"]');
		const arrten = $('input:radio[name="q10"]');

		let fever = 0;
		let nasal = 0;
		let throat = 0;
		let cough = 0;

		if(arrone[1].checked || arrone[2].checked) { fever = 1; }
		if(arrtwo[1].checked || arrtwo[2].checked) { nasal = 1; }
		if(arrthree[1].checked || arrthree[2].checked) { throat = 1; }
		if(arrfour[1].checked || arrfour[2].checked) { cough = 1; }

		let cold = nasal + throat + cough;
		//alert(cold);return false;

		let colddx = "";
		let pcrdx = "";
		let sepsisdx = "";
		let fatiguedx = "";
		let headeckedx = "";
		let arthritisdx = "";
		let rashdx = "";

		if(cold === 0) {
			colddx = "可能性低い";
		} else if(cold === 1 || cold === 2) {
			colddx = "可能性あり";
		} else if(cold === 3) {
			colddx = "可能性高い";
		}
		//alert(colddx);return false;
		
		if(cold + fever === 0) {
			pcrdx = "状況に応じて検討";
		} else {
			pcrdx = "必要あり";
		}
		//alert(pcrdx);return false;
		
		if(fever === 1 && arrfive[2].checked) {
			sepsisdx = "可能性あり。尿路感染や胆嚢・胆管炎を考慮";
		} else if(fever === 1 && arrfive[3].checked) {
			sepsisdx = "可能性高い。尿路感染や胆嚢・胆管炎を考慮";
		} else {
			sepsisdx = "";
		}
		//alert(sepsisdx);return false;
		
		if(fever === 1 && arrseven[2].checked) {
			fatiguedx = "急性肝炎や急性心筋炎、伝染性単核球症などを考慮。鑑別診断は多い";
		} else {
			fatiguedx = "";
		}
		//alert(fatiguedx);return false;
		
		if(fever === 1 && arreight[2].checked) {
			headeckedx = "細菌性髄膜炎を考慮し、腰椎穿刺を検討";
		} else {
			headeckedx = "";
		}
		//alert(headeckedx);return false;
		
		if(fever === 1 && arrnine[1].checked) {
			abddx = "心筋梗塞や小脳梗塞も鑑別する";
		} else if(fever === 1 && arrnine[2].checked) {
			abddx = "急性胃腸炎の可能性が高い";
		} else if(fever === 1 && arrnine[3].checked) {
			abddx = "虫垂炎や憩室炎に注意";
		} else {
			abddx = "";
		}
		//alert(abddx);return false;
		
		if(fever === 1 && cold > 0 && arrten[1].checked) {
			arthritisdx = "パルボウイルス等の感染を考える";
		} else if(fever === 1 && cold === 0 && arrten[1].checked) {
			arthritisdx = "結晶性関節炎等を検討";
		} else{
			arthritisdx = "";
		}
		//alert(arthritisdx);return false;

		$('#COLD').text(colddx);
		$('#PCR').text(pcrdx);
		$('#SEPSIS').text(sepsisdx);
		$('#FATIGGUE').text(fatiguedx);
		$('#HEADACKE').text(headeckedx);
		$('#ABDOMEN').text(abddx);
		$('#ARTHRITIS').text(arthritisdx);
	});
});
</script>
@stop
