<!-- toolbar -->
<div class="d-flex justify-content-center align-items-center mb-3">
	<div>
		<a
			class="text-danger"
			href="{!! $last_link !!}"
		>
			<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
		</a>
	</div>
	<div class="mx-4">
		<h4 class="mb-0">
			{!! \Carbon\Carbon::create(
				$yy,
				$mm,
				1
			)->format('Y年n月') !!}
		</h4>
	</div>
	<div>
		<a
			class="text-danger"
			href="{!! $next_link !!}"
		>
			<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
		</a>
	</div>
</div>
<!-- /.toolbar -->

<div class="card">
	<div class="card-body p-4">
		<!-- table -->
		<div class="table-responsive">
			<table class="table">
				<colgroup>
					<col width="14%">
					<col width="14%">
					<col width="14%">
					<col width="14%">
					<col width="14%">
					<col width="14%">
					<col width="14%">
				</colgroup>
				<thead class="">
					<tr class="text-center">
						<th>
							日
						</th>
						<th>
							月
						</th>
						<th>
							火
						</th>
						<th>
							水
						</th>
						<th>
							木
						</th>
						<th>
							金
						</th>
						<th>
							土
						</th>
					</tr>
				</thead>
				<tbody class="table-group-divider">
					<tr class="text-center">
						@php
							$cols = 1;
						@endphp
						@for($i = 1; $i <= ($date['day'] + $date['week']); $i++)
							@php
								$j = $i - $date['week'];
							@endphp

							@if($j < 1)
								<td nowrap class="p-2">
									&nbsp;
								</td>
							@else
								<td nowrap class="p-2">
									<div class="mb-2">
										<span class="fs-4">{!! $j !!}</span>
									</div>

									<ul class="list-inline mb-0">
										@if(isset($stock_list[$j]))
											<li class="list-inline-item">
												<span class="{!! ($stock_list[$j]['stock3'] > 0) ? 'text-primary' : 'text-muted' !!}">
													小:{!! $stock_list[$j]['stock3'] !!}
												</span>
											</li>
											<li class="list-inline-item">
												<span class="{!! ($stock_list[$j]['stock2'] > 0) ? 'text-primary' : 'text-muted' !!}">
													中:{!! $stock_list[$j]['stock2'] !!}
												</span>
											</li>
                                            <li class="list-inline-item">
												<span class="{!! ($stock_list[$j]['stock1'] > 0) ? 'text-primary' : 'text-muted' !!}">
													大:{!! $stock_list[$j]['stock1'] !!}
												</span>
											</li>
										@else
											<li class="list-inline-item">
												<span class="text-muted">
													空車なし
												</span>
											</li>
										@endif
									</ul>
								</td>
							@endif

							@if(($i % 7) == 0)
								@php
									$cols = 0;
								@endphp
								</tr>
								@if($j != $date['day'])
									<tr class="text-center">
								@endif
							@else
								@if($i == ($date['day'] + $date['week']))
									@for($k = ($cols + 1); $k <= 7; $k++)
										<td>&nbsp;</td>
									@endfor
								@endif
							@endif

							@php
								$cols++;
							@endphp
						@endfor
			</table>
		</div>
		<!-- /.table -->
	</div>
</div>
