<!DOCTYPE html>
<html lang="{!! str_replace('_', '-', app()->getLocale()) !!}" class="h-100">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, shrink-to-fit=no">
	<title></title>

	<!-- favicon -->
	<link
		rel="icon"
		href="{!! implode('/', [
			asset('img'),
			'favicon.png',
		]) !!}"
		sizes="32x32"
		type="image/png"
	>

	{{-- bootstrap --}}
	{{-- @vite([
		'resources/sass/app.scss',
		'resources/js/app.js'
	]) --}}
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">

	<link
		href="{!! implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'ui.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>
	<link
		href="{!! implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'custom.css',
		]) !!}?timestamp={!! date('YmdHis') !!}"
		rel="stylesheet"
	>

	<link
		href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
		rel="stylesheet"
		integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
		crossorigin="anonymous"
		referrerpolicy="no-referrer"
	>

	<style>
	html, body {
		height: 100%;
	}

	body {
		display: flex;
		align-items: center;
		padding-top: 4rem;
		padding-bottom: 4rem;
	}

	.form-signin {
		max-width: 330px;
		padding: 15px;
	}
	</style>

	@yield('css')
</head>

<body class="text-center">

	<!-- preloader-->
	<div class="preloader" id="preloader">
		<div class="spinner-grow" role="status">
		<span class="visually-hidden">Loading...</span>
		</div>
	</div>
	<!-- /.preloader -->

	<!-- main -->
	<main class="w-100 m-auto">
		<div class="container">
			@yield('content')
		</div>
	</main>
	<!-- /.main -->

	<!-- jquery -->
	<script
		src="{!! implode('/', [
			asset('vendors'),
			'jquery',
			'jquery.min.js',
		]) !!}"
	></script>

	{{-- bootstrap5.2.3 by cdn --}}
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js" integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V" crossorigin="anonymous"></script>

	<!-- custom -->
	<script
		src="{!! implode('/', [
			asset('templates'),
			'mobile',
			'js',
			'script.js',
		]) !!}"
	></script>
	<script
		src="{!! implode('/', [
			asset('templates'),
			'mobile',
			'js',
			'pwa.js',
		]) !!}"
	></script>

	<script>
	$(function() {

	});
	</script>

	@yield('js')
</body>
</html>
