<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\Controller;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('ajax')
    ->name('ajax.')
    ->namespace('Ajax')
    ->group(function () {
        Route::name('voucher_number_exists')
            ->get('voucher-number-exists/{voucher_number}', 'AjaxController@voucherNumberExists')
            ->where('voucher_number', '[-0-9A-Za-z_.\s]+');
    });
