<?php

use Illuminate\Support\Facades\Route;
use App\Events\CheckedinEvent;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
// 	return view('welcome');
// });

// Route::get('/bootstrap', function () {
// 	return view('bootstrap');
// });

// Auth::routes();

//Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

/**
 * ==================================================
 * frontend
 * ==================================================
 */
Route::prefix('/')
	//->middleware('auth')
	->name('frontend.')
	->namespace('Frontend')
	->group(function () {

		/**
		 * ==================================================
		 * covid
		 * ==================================================
		 */
		Route::prefix('covid')
			->name('covid.')
			->namespace('Covid')
			->group(function () {

				/**
				 * --------------------------------------------------
				 * booking
				 * --------------------------------------------------
				 */
				Route::prefix('booking')
					->name('booking.')
					->namespace('Booking')
					->group(function () {

						// home
						Route::name('home.index')
							->get('', 'HomeController@index');

						Route::name('home.test')
							->get('test', 'HomeController@test');

						// agreement
						Route::name('agreement.index')
							->get('agreement/index', 'AgreementController@index');

						// // consent
						// Route::name('consent.index')
						//     ->get('consent/index', 'ConsentController@index');

						// Route::name('consent.store')
						//     ->post('consent/store', 'ConsentController@store');

						// personal
						Route::name('personal.index')
							->get('personal/index', 'PersonalController@index');

						Route::name('personal.store')
							->post('personal/store', 'PersonalController@store');

						// disease
						Route::name('disease.index')
							->get('disease/index', 'DiseaseController@index');

						Route::name('disease.store')
							->post('disease/store', 'DiseaseController@store');

						// condition
						Route::name('condition.index')
							->get('condition/index', 'ConditionController@index');

						Route::name('condition.store')
							->post('condition/store', 'ConditionController@store');

						// vaccine
						Route::name('vaccine.index')
							->get('vaccine/index', 'VaccineController@index');

						Route::name('vaccine.store')
							->post('vaccine/store', 'VaccineController@store');

						// datetime
						Route::name('datetime.index')
							->get('datetime/index/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'DatetimeController@index')
							->where('yy', '[-0-9A-Za-z_.\s]+')
							->where('mm', '[-0-9A-Za-z_.\s]+')
							->where('dd', '[-0-9A-Za-z_.\s]+')
							->where('hh', '[-0-9A-Za-z_.\s]+')
							->where('ii', '[-0-9A-Za-z_.\s]+');

						Route::name('datetime.store')
							->post('datetime/store', 'DatetimeController@store');

						Route::name('datetime.error')
							->get('datetime/error', 'DatetimeController@error');

						// pencil
						Route::name('pencil.index')
							->get('pencil/index', 'PencilController@index');

						Route::name('pencil.store')
							->post('pencil/store', 'PencilController@store');

						// qr
						Route::name('qr.index')
							->get('qr/index', 'QrController@index');

						Route::name('qr.store')
							->post('qr/store', 'QrController@store');

						Route::name('qr.test')
							->get('qr/test', 'QrController@test');

						// guest
						Route::name('guest.index')
							->get('guest/index', 'GuestController@index');

						Route::name('guest.store')
							->post('guest/store', 'GuestController@store');

						// confirm
						Route::name('confirm.index')
							->get('confirm/index', 'ConfirmController@index');

						Route::name('confirm.store')
							->post('confirm/store', 'ConfirmController@store');

						Route::name('confirm.complete')
							->get('confirm/complete', 'ConfirmController@complete');

						/**
						 * --------------------------------------------------
						 * mypage
						 * --------------------------------------------------
						 */
						Route::prefix('mypage')
							->name('mypage.')
							->namespace('Mypage')
							->group(function () {

								// signin
								Route::name('signin.index')
									->get('signin/index', 'SigninController@index');

								// signin directly
								Route::name('signin.show')
									->get('signin/show/{yy}/{mm}/{dd}/{signin_code}', 'SigninController@show')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('signin_code', '[-0-9A-Za-z_.\s]+');

								Route::name('signin.store')
									->post('signin/store', 'SigninController@store');

								Route::name('signin.destroy')
									->get('signout', 'SigninController@destroy');

								// qr
								Route::name('qr.index')
									->get('qr/index/{yy}/{mm}/{dd}/{signin_code}', 'QrController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('signin_code', '[-0-9A-Za-z_.\s]+');

								/**
								 * ==================================================
								 * middleware
								 * ==================================================
								 */
								// Route::middleware('covid')
								Route::middleware('covid.mypage')
									->group(function () {

										// guest
										// Route::name('guest.index')
										//     ->get('guest/index', 'GuestController@index');

										Route::name('guest.show')
											->get('guest/show', 'GuestController@show');

										// vaccine
										Route::name('vaccine.index')
											->get('vaccine/index', 'VaccineController@index');

										Route::name('vaccine.store')
											->post('vaccine/store', 'VaccineController@store');

										// edit
										Route::name('edit.index')
											->get('edit/index', 'EditController@index');

										Route::name('edit.show')
											->get('edit/show', 'EditController@show');

										Route::name('edit.update')
											->get('edit/update/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'EditController@update')
											->where('yy', '[-0-9A-Za-z_.\s]+')
											->where('mm', '[-0-9A-Za-z_.\s]+')
											->where('dd', '[-0-9A-Za-z_.\s]+')
											->where('hh', '[-0-9A-Za-z_.\s]+')
											->where('ii', '[-0-9A-Za-z_.\s]+');

										Route::name('edit.confirm')
											->post('edit/confirm', 'EditController@confirm');

										Route::name('edit.store')
											->post('edit/store', 'EditController@store');

										Route::name('edit.complete')
											->get('edit/complete', 'EditController@complete');

										Route::name('edit.destroy')
											->get('edit/destroy', 'EditController@destroy');

										Route::name('edit.error')
											->get('edit/error', 'EditController@error');

										// booking
										Route::name('booking.store')
											->post('booking/store', 'BookingController@store');

										Route::name('booking.update')
											->get('booking/update/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'BookingController@update')
											->where('yy', '[-0-9A-Za-z_.\s]+')
											->where('mm', '[-0-9A-Za-z_.\s]+')
											->where('dd', '[-0-9A-Za-z_.\s]+')
											->where('hh', '[-0-9A-Za-z_.\s]+')
											->where('ii', '[-0-9A-Za-z_.\s]+');

										Route::name('booking.destroy')
											->get('booking/destroy', 'BookingController@destroy');
								});
						});
				});

				/**
				 * Sep 04, 2024
				 * --------------------------------------------------
				 * booking2
				 * --------------------------------------------------
				 */
				Route::prefix('booking2')
					->name('booking2.')
					->namespace('Booking2')
					->group(function () {

						// HomeController
						Route::controller(HomeController::class)
							->prefix('')
							->name('home.')
							->group(function() {
								
								Route::get('', 'index')
									->name('index');
						});

						// AgreementController
						Route::controller(AgreementController::class)
							->prefix('agreement')
							->name('agreement.')
							->group(function() {
								
								Route::get('', 'index')
									->name('index');
						});

						// DatetimeController
						Route::controller(DatetimeController::class)
							->prefix('datetime')
							->name('datetime.')
							->group(function() {
								
								Route::get('{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'index')
									->name('index');

								Route::post('store', 'store')
									->name('store');
						});

						// PdfController
						Route::controller(PdfController::class)
							->prefix('pdf')
							->name('pdf.')
							->group(function() {
								
								Route::get('create/{signin_code}', 'create')
									->name('create');
						});

						/**
						 * --------------------------------------------------
						 * middleware
						 * --------------------------------------------------
						 */
						Route::middleware('covid.booking2')
							->group(function () {

								// SubConfirmController
								Route::controller(SubConfirmController::class)
									->prefix('subconfirm')
									->name('subconfirm.')
									->group(function() {

										Route::get('', 'index')
											->name('index');

										Route::post('store', 'store')
											->name('store');
								});
								
								// GuestController
								Route::controller(GuestController::class)
									->prefix('guest')
									->name('guest.')
									->group(function() {
										
										Route::get('', 'index')
											->name('index');

										Route::post('store', 'store')
											->name('store');
								});

								// FormController
								Route::controller(FormController::class)
									->prefix('form')
									->name('form.')
									->group(function() {
										
										Route::get('', 'index')
											->name('index');

										Route::post('store', 'store')
											->name('store');
								});

								// ConfirmController
								Route::controller(ConfirmController::class)
									->prefix('confirm')
									->name('confirm.')
									->group(function() {

										Route::get('', 'index')
											->name('index');

										Route::post('store', 'store')
											->name('store');

										Route::get('complete', 'complete')
											->name('complete');
								});
						});

						/**
						 * --------------------------------------------------
						 * mypage
						 * --------------------------------------------------
						 */
						Route::prefix('mypage')
							->name('mypage.')
							->namespace('Mypage')
							->group(function () {

								// signin
								Route::name('signin.index')
									->get('signin/index', 'SigninController@index');

								// signin directly
								Route::name('signin.show')
									->get('signin/show/{yy}/{mm}/{dd}/{signin_code}', 'SigninController@show')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('signin_code', '[-0-9A-Za-z_.\s]+');

								Route::name('signin.store')
									->post('signin/store', 'SigninController@store');

								Route::name('signin.destroy')
									->get('signout', 'SigninController@destroy');

								// qr
								Route::name('qr.index')
									->get('qr/index/{yy}/{mm}/{dd}/{signin_code}', 'QrController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('signin_code', '[-0-9A-Za-z_.\s]+');

								/**
								 * ==================================================
								 * middleware
								 * ==================================================
								 */
								Route::middleware('covid.mypage2')
									->group(function () {

										// DatetimeController
										Route::controller(DatetimeController::class)
											->prefix('datetime')
											->name('datetime.')
											->group(function() {
												
												Route::get('update/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'update')
													->name('update');

												Route::post('store', 'store')
													->name('store');

												Route::post('confirm', 'confirm')
													->name('confirm');

												Route::get('complete', 'complete')
													->name('complete');
										});

										// guest
										// Route::name('guest.index')
										//     ->get('guest/index', 'GuestController@index');

										Route::name('guest.show')
											->get('guest/show', 'GuestController@show');

										// vaccine
										Route::name('vaccine.index')
											->get('vaccine/index', 'VaccineController@index');

										Route::name('vaccine.store')
											->post('vaccine/store', 'VaccineController@store');

										// edit
										Route::name('edit.index')
											->get('edit/index', 'EditController@index');

										Route::name('edit.show')
											->get('edit/show', 'EditController@show');

										Route::name('edit.update')
											->get('edit/update/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'EditController@update')
											->where('yy', '[-0-9A-Za-z_.\s]+')
											->where('mm', '[-0-9A-Za-z_.\s]+')
											->where('dd', '[-0-9A-Za-z_.\s]+')
											->where('hh', '[-0-9A-Za-z_.\s]+')
											->where('ii', '[-0-9A-Za-z_.\s]+');

										Route::name('edit.confirm')
											->post('edit/confirm', 'EditController@confirm');

										Route::name('edit.store')
											->post('edit/store', 'EditController@store');

										Route::name('edit.complete')
											->get('edit/complete', 'EditController@complete');

										Route::name('edit.destroy')
											->get('edit/destroy', 'EditController@destroy');

										Route::name('edit.error')
											->get('edit/error', 'EditController@error');

										// booking
										Route::name('booking.store')
											->post('booking/store', 'BookingController@store');

										Route::name('booking.update')
											->get('booking/update/{yy?}/{mm?}/{dd?}/{hh?}/{ii?}', 'BookingController@update')
											->where('yy', '[-0-9A-Za-z_.\s]+')
											->where('mm', '[-0-9A-Za-z_.\s]+')
											->where('dd', '[-0-9A-Za-z_.\s]+')
											->where('hh', '[-0-9A-Za-z_.\s]+')
											->where('ii', '[-0-9A-Za-z_.\s]+');

										Route::name('booking.destroy')
											->get('booking/destroy', 'BookingController@destroy');
								});
						});
				});

				/**
				 * --------------------------------------------------
				 * frontdesk
				 * --------------------------------------------------
				 */
				Route::prefix('frontdesk')
					->name('frontdesk.')
					->namespace('Frontdesk')
					->group(function () {

						// qr
						Route::name('qr.index')
							->get('qr/index/{yy?}/{mm?}/{dd?}', 'QrController@index')
							->where('yy', '[-0-9A-Za-z_.\s]+')
							->where('mm', '[-0-9A-Za-z_.\s]+')
							->where('dd', '[-0-9A-Za-z_.\s]+');

						Route::name('qr.show')
							->post('qr/show', 'QrController@show');

						Route::name('qr.store')
							->post('qr/store', 'QrController@store');

						Route::name('qr.complete')
							->get('qr/complete/{yy?}/{mm?}/{dd?}', 'QrController@complete')
							->where('yy', '[-0-9A-Za-z_.\s]+')
							->where('mm', '[-0-9A-Za-z_.\s]+')
							->where('dd', '[-0-9A-Za-z_.\s]+');
				});

				/**
				 * --------------------------------------------------
				 * mobile
				 * --------------------------------------------------
				 */
				Route::prefix('mobile')
					->name('mobile.')
					->namespace('Mobile')
					->group(function () {

						// status
						Route::name('status.index')
							->get('status/index/{yy?}/{mm?}/{dd?}/{hh?}', 'StatusController@index')
							->where('yy', '[-0-9A-Za-z_.\s]+')
							->where('mm', '[-0-9A-Za-z_.\s]+')
							->where('dd', '[-0-9A-Za-z_.\s]+')
							->where('hh', '[-0-9A-Za-z_.\s]+');
				});

				/**
				 * --------------------------------------------------
				 * guidance
				 * --------------------------------------------------
				 */
				Route::prefix('guidance')
					->name('guidance.')
					->namespace('Guidance')
					->group(function () {

						// home
						Route::name('home.index')
							->get('', 'HomeController@index');

						// main
						Route::name('main.index')
							->get('main', 'MainController@index');

						// qa
						Route::name('qa.index')
							->get('qa/{page?}', 'QaController@index')
							->where('page', '[-0-9A-Za-z_.\s]+');

						/**
						 * --------------------------------------------------
						 * modal
						 * --------------------------------------------------
						 */
						Route::prefix('modal')
							->name('modal.')
							->namespace('Modal')
							->group(function () {

								Route::name('fever.index')
									->get('fever/index', 'FeverController@index');

								Route::name('qr.store')
									->post('fever/store', 'FeverController@store');
						});
				});
		});

		/**
		 * ==================================================
		 * flu
		 * ==================================================
		 */
		Route::prefix('flu')
			->name('flu.')
			->namespace('Flu')
			->group(function () {
		});
});


/**
 * ==================================================
 * backend
 * ==================================================
 */
Route::prefix('admin')
	->name('admin.')
	->namespace('Backend')
	->group(function () {

		// signin
		Route::name('signin.index')
			->get('', 'SigninController@index');

		Route::name('signin.store')
			->post('signin/store', 'SigninController@store');

		Route::name('signin.show')
			->get('signin/show', 'SigninController@show');

		Route::name('signin.destroy')
			->get('signput', 'SigninController@destroy');

		/**
		 * --------------------------------------------------
		 * middleware
		 * --------------------------------------------------
		 */
		Route::middleware('backend.staff')
			->group(function () {

				// home
				Route::name('home.index')
					->get('home/{yy?}/{mm?}/{dd?}', 'HomeController@index')
					->where('yy', '[-0-9A-Za-z_.\s]+')
					->where('mm', '[-0-9A-Za-z_.\s]+')
					->where('dd', '[-0-9A-Za-z_.\s]+');

				// master
				Route::name('master.index')
					->get('master/index', 'MasterController@store');

				// maintenance
				Route::name('maintenance.index')
					->get('maintenance/index', 'MaintenanceController@index');

				/**
				 * --------------------------------------------------
				 * covid
				 * --------------------------------------------------
				 */
				Route::prefix('covid')
					->name('covid.')
					->namespace('Covid')
					->group(function () {

						// master
						Route::name('master.index')
							->get('master/index/{table}/{id?}', 'MasterController@index')
							->where('table', '[-0-9A-Za-z_.\s]+')
							->where('id', '[-0-9A-Za-z_.\s]+');

						Route::name('master.store')
							->post('master/store', 'MasterController@store');

						/**
						 * --------------------------------------------------
						 * booking
						 * --------------------------------------------------
						 */
						Route::prefix('booking')
							->name('booking.')
							->namespace('Booking')
							->group(function () {

								// calendar
								Route::name('calendar.index')
									->get('calendar/index/{yy?}/{mm?}/{mtb_vaccine_id?}', 'CalendarController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('mtb_vaccine_id', '[-0-9A-Za-z_.\s]+');

								// status
								Route::name('status.index')
									->get('status/index/{yy?}/{mm?}/{dd?}/{is_pm?}', 'StatusController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('is_pm', '[-0-9A-Za-z_.\s]+');

								Route::name('status.store')
									->post('status/store', 'StatusController@store');

								Route::name('status.show')
									->get('status/show/{yy}/{mm}/{dd}/{booking_code}', 'StatusController@show')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('booking_code', '[-0-9A-Za-z_.\s]+');

								Route::name('status.update')
									->get('status/update/{yy}/{mm}/{dd}/{mtb_vaccine_id?}/{booking_code?}', 'StatusController@update')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('mtb_vaccine_id', '[-0-9A-Za-z_.\s]+')
									->where('booking_code', '[-0-9A-Za-z_.\s]+');

								Route::name('status.destroy')
									->get('status/destroy/{yy}/{mm}/{dd}/{booking_code}', 'StatusController@destroy')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('booking_code', '[-0-9A-Za-z_.\s]+');

								// search
								Route::name('search.index')
									->get('search/index/{yy?}/{mm?}/{dd?}', 'SearchController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');

								Route::name('search.store')
									->post('search/store', 'SearchController@store');

								// PdfController
								Route::controller(PdfController::class)
									->prefix('pdf')
									->name('pdf.')
									->group(function() {
										
										Route::get('create/{booking_code}', 'create')
											->name('create');
								});

								// BulkController
								Route::controller(BulkController::class)
									->prefix('bulk')
									->name('bulk.')
									->group(function() {
										
										Route::post('store', 'store')
											->name('store');
								});
						});


						/**
						 * --------------------------------------------------
						 * booking2
						 * --------------------------------------------------
						 */
						Route::prefix('booking2')
							->name('booking2.')
							->namespace('Booking2')
							->group(function () {


						});

						/**
						 * --------------------------------------------------
						 * frontdesk
						 * --------------------------------------------------
						 */
						Route::prefix('frontdesk')
							->name('frontdesk.')
							->namespace('Frontdesk')
							->group(function () {

								// status
								Route::name('status.index')
									->get('status/index/{yy?}/{mm?}/{dd?}', 'StatusController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');

								// qr
								Route::name('qr.index')
									->get('qr/index/{yy?}/{mm?}/{dd?}', 'QrController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');

								Route::name('qr.store')
									->post('qr/store', 'QrController@store');

								Route::name('qr.show')
									->get('qr/show/{yy}/{mm}/{dd}/{booking_code?}', 'QrController@show')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('booking_code', '[-0-9A-Za-z_.\s]+');

								// list
								Route::name('list.index')
									->get('list/index/{yy?}/{mm?}/{dd?}/{is_checkedin?}', 'ListController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+')
									->where('is_checkedin', '[-0-9A-Za-z_.\s]+');

								Route::name('list.store')
									->post('list/store', 'ListController@store');
						});

						/**
						 * --------------------------------------------------
						 * master
						 * --------------------------------------------------
						 */
						Route::prefix('master')
							->name('master.')
							->namespace('Master')
							->group(function () {

								// accepted_number
								Route::name('acceptednumber.index')
									->get('acceptednumber/index/{mtb_accepted_number_id?}', 'AcceptedNumberController@index')
									->where('mtb_accepted_number_id', '[-0-9A-Za-z_.\s]+');

								Route::name('acceptednumber.store')
									->post('acceptednumber/store', 'AcceptedNumberController@store');

								// date
								Route::name('date.index')
									->get('date/index/{yy?}/{mm?}', 'DateController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+');

								Route::name('date.store')
									->post('date/store', 'DateController@store');

								Route::name('date.update')
									->get('date/update/{yy}/{mm}/{dd}', 'DateController@update')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');

								// publish
								Route::name('publish.store')
									->post('publish/store', 'PublishController@store');

								Route::name('publish.update')
									->get('publish/update', 'PublishController@update');

								// vaccine
								Route::name('vaccine.index')
									->get('vaccine/index/{mtb_vaccine_id?}', 'VaccineController@index')
									->where('mtb_vaccine_id', '[-0-9A-Za-z_.\s]+');

								Route::name('vaccine.store')
									->post('vaccine/store', 'VaccineController@store');
						});

						/**
						 * --------------------------------------------------
						 * export
						 * --------------------------------------------------
						 */
						Route::prefix('export')
							->name('export.')
							->namespace('Export')
							->group(function () {

								// day
								Route::name('day.index')
									->get('day/index/{yy?}/{mm?}/{dd?}', 'DayController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');

								// vaccine
								Route::name('vaccine.index')
									->get('vaccine/index/{yy?}/{mm?}/{dd?}', 'VaccineController@index')
									->where('yy', '[-0-9A-Za-z_.\s]+')
									->where('mm', '[-0-9A-Za-z_.\s]+')
									->where('dd', '[-0-9A-Za-z_.\s]+');
						});
				});

				/**
				 * --------------------------------------------------
				 * maintenance
				 * --------------------------------------------------
				 */
				Route::prefix('maintenance')
					->name('maintenance.')
					->namespace('Maintenance')
					->group(function () {

						// voucher
						Route::name('vouchernumber.index')
							->get('vouchernumber/index', 'VoucherNumberController@index');

						Route::name('vouchernumber.store')
							->post('vouchernumber/store', 'VoucherNumberController@store');

						Route::name('vouchernumber.complete')
							->get('vouchernumber/complete', 'VoucherNumberController@complete');
				});

		});
});


/**
 * ==================================================
 * Event
 * ==================================================
 */
Route::name('event.checkedin')->get('/checkedin', function () {
	event(new CheckedinEvent);
});

/**
 * ==================================================
 * ajax
 * ==================================================
 */
Route::prefix('ajax')
	->name('ajax.')
	->namespace('Ajax')
	->group(function () {

		// ischeckedin
		Route::name('ischeckedin.update')
			->get('ischeckedin/update/{booking_code?}/{is_checkedin?}', 'IsCheckedinController@update')
			->where('booking_code', '[-0-9A-Za-z_.\s]+')
			->where('is_checkedin', '[-0-9A-Za-z_.\s]+');

		// time
		Route::name('time.index')
			->get('time/index/{yy?}/{mm?}/{dd?}', 'TimeController@index')
			->where('yy', '[-0-9A-Za-z_.\s]+')
			->where('mm', '[-0-9A-Za-z_.\s]+')
			->where('dd', '[-0-9A-Za-z_.\s]+');
});
