<?php $__env->startSection('content'); ?>
<?php echo $__env->make('frontend.layouts.components.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- section -->
<section class="mb-5">
	<div class="container">

		<div class="section-title text-center mb-4">
			<h3>
				予約変更・キャンセル
			</h3>
		</div>
		<p class="mb-3">
			予約内容を変更する場合は「予約変更」、キャンセルする場合は「予約キャンセル」をタップしてください
		</p>

		<div
			class="alert alert-primary lead mb-4"
			role="alert"
		>
			<div class="d-flex justify-content-between align-items-center mb-2">
				<div class="">
					<span class="small fw-bold">
						予約日
					</span>
				</div>
				<div>
					<?php echo \Carbon\Carbon::create($booking['yy'], $booking['mm'], $booking['dd'])->isoFormat('YYYY年M月D日（ddd）'); ?>

				</div>
			</div>
			<div class="d-flex justify-content-between align-items-center mb-2">
				<div class="">
					<span class="small fw-bold">
						予約時間
					</span>
				</div>
				<div>
					<?php echo \Carbon\Carbon::create(
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['hh'],
						$booking['ii'],
					)->format(__('lang.date.hhii')); ?>

				</div>
			</div>
			<div class="d-flex justify-content-between align-items-center mb-2">
				<div class="">
					<span class="small fw-bold">
						接種会場
					</span>
				</div>
				<div>
					平和台病院
				</div>
			</div>
			<div class="d-flex justify-content-between align-items-center mb-0">
				<div class="">
					<span class="small fw-bold">
						ワクチンの種類
					</span>
				</div>
				<div>
					<?php echo $booking['vaccine_label']; ?>

				</div>
			</div>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<a
			class="btn btn-primary btn-lg w-100"
			href="<?php echo route('frontend.covid.booking.mypage.vaccine.index'); ?>"
		>
			<span class="fw-bold">
				予約変更
			</span>
		</a>
		<a
			class="btn btn-outline-danger btn-lg border border-danger border-3 w-100"
			data-bs-toggle="modal"
			data-bs-target="#modal-cancel"
		>
			<span class="fw-bold">
				予約<?php echo __("lang.button.cancel"); ?>

			</span>
		</a>
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-3"
			href="<?php echo route('frontend.covid.booking.mypage.guest.show'); ?>"
		>
			<span class="fw-bold">
				<?php echo __('lang.button.back'); ?>

			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->

<!-- modal -->
<div
	class="modal fade"
	id="modal-cancel"
	data-bs-backdrop="static"
	data-bs-keyboard="false"
	tabindex="-1"
	aria-hidden="true"
>
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content">
			<div class="modal-header">
				<h1 class="modal-title fs-5">
					予約をキャンセルしますか？
				</h1>
				<button
					type="button"
					class="btn-close"
					data-bs-dismiss="modal"
					aria-label="Close"
				></button>
			</div>
			<div class="modal-body">
				<p class="fs-5">「はい」を選択すると、予約をキャンセルしHOME画面に戻ります。</p>
				<p class="fs-5">再度予約する場合はHOME画面の「予約にすすむ」ボタンより手続きをしていただく必要があります。</p>
				<p class="fs-5">本当にキャンセルしてよろしいですか？</p>
			</div>
			<div class="modal-footer">
				<a
					class="btn btn-danger"
					href="<?php echo route('frontend.covid.booking.mypage.edit.destroy'); ?>"
				>
					<span class="fw-bold">
						<?php echo __("lang.dictionary.is_yesno.1"); ?>

					</span>
				</a>

				<button
					class="btn btn-secondary"
					type="button"
					data-bs-dismiss="modal"
				>
					<span class="fw-bold">
						<?php echo __("lang.dictionary.is_yesno.0"); ?>

					</span>
				</button>
			</div>
		</div>
	</div>
</div>
<!-- /.moda -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
	$(function() {
		//
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking/mypage/edit/index.blade.php ENDPATH**/ ?>