<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>


<!-- section -->
<section class="mb-0">
    <div class="container">

        <div
            class="alert alert-primary"
            role="alert"
        >
            <h4 class="alert-heading text-center mb-1">
                予約の変更・キャンセル
            </h4>
            <p>
                ワクチン予約の変更・キャンセルをご希望の方は、接種券番号と生年月日を入力し本人認証してください。
            </p>
            <hr>
            <p>
                カメラアクセスを許可して、QRコードを読み取ってください。
                読み取れない場合はお手数ですが、接種券番号を直接ご入力ください。
            </p>
        </div>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger mb-3">
                <ul class="mb-0 ps-3">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <?php echo $error; ?>

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        
    </div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
    <div class="container">
		<div class="text-center bg-black mb-3 pt-3 pb-2">
			<canvas id="preview"></canvas>
		</div>

        <div class="mb-2">
            <label
                class="form-label"
                for=""
            >
                <span class="badge rounded-pill text-bg-danger me-2">
                    <?php echo __("lang.form.required"); ?>

                </span>
                <span class="fw-bold">
                    接種券番号（10桁）
                </span>
            </label>
            <?php echo Form::text('booking[voucher_number]', '', [
                'class' => 'form-control form-control-lg',
                'id' => 'qr',
                'minlength' => 10,
                'maxlength' => 10,
            ]); ?>

        </div>

		<div
			class="alert alert-danger text-center mb-2 px-1"
			id="alert"
			role="alert"
            style="display: none;"
		>
			<div class="mb-3">
				<i class="fa-solid fa-circle-exclamation fa-fw fa-3x"></i>
			</div>
			<p
				class="fw-bold mb-0"
				style="font-size:1.1rem;"
			>
				読み取った接種券番号をご確認ください<br>
				お間違いありませんか？
			</p>
		</div>

        <div class="mb-0">
            <label
                class="form-label"
                for=""
            >
                <span class="badge rounded-pill text-bg-danger me-2">
                    <?php echo __("lang.form.required"); ?>

                </span>
                <span class="fw-bold">
                    生年月日（西暦）
                </span>
            </label>
            <div class="input-group input-group-lg mb-0">
                <?php echo Form::select('birthday[yy]', $date_list['year_list'], 1970,[
                    'class' => 'form-select',
                ]); ?>

                <?php echo Form::select('birthday[mm]', $date_list['month_list'], '',[
                    'class' => 'form-control text-center',
                ]); ?>

                <?php echo Form::select('birthday[dd]', $date_list['day_list'], '',[
                    'class' => 'form-control text-center',
                ]); ?>

            </div>
        </div>

    </div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
    <div class="d-grid gap-2 w-100">
        <div class="d-flex">
            <div class="flex-grow-1 me-2">
                <button
                    class="btn btn-primary btn-lg border border-primary border-3 w-100"
                    type="submit"
                    name="action"
                    value="store"
                >
                    <span class="fw-bold">
                        <?php echo __("lang.button.signin"); ?>

                    </span>
                </button>
            </div>
            <div>
                <a
                    class="btn btn-outline-secondary btn-lg border border-secondary border-3"
                    href="<?php echo route('frontend.covid.booking.home.index'); ?>"
                >
                    <span class="fw-bold text-dark">
                        <?php echo __("lang.button.home"); ?>

                    </span>
                </a>
            </div>
        </div>
    </div>
</nav>
<!-- /.nav -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<!-- jsQR -->
<script
	src="<?php echo implode('/', [
		asset('vendors'),
		'jsQR',
		'jsQR.js',
	]); ?>"
></script>

<script
	src="<?php echo implode('/', [
		asset('templates'),
		'mobile',
		'js',
		"qr.js?timestamp={date('YmdHis')}",
	]); ?>"
></script>

<script>
$(function() {
    //
});

let Scan = () => {

	//選択された幅高さ
	w = video.videoWidth;
	h = video.videoHeight;

	//画面上の表示サイズ
	prev.style.width = (w/2) + "px";
	prev.style.height = (h/2) + "px";

	//内部のサイズ
	prev.setAttribute("width", w);
	prev.setAttribute("height", h);
	if(w > h){ m = h * 0.6; } else { m = w * 0.6; }

	x1 = (w - m) / 2;
	y1 = (h - m) / 2;
	prev_ctx.drawImage(video, 0, 0, w, h);
	prev_ctx.beginPath();
	prev_ctx.strokeStyle = "rgb(255, 255, 0)";
	prev_ctx.lineWidth = 6;
	prev_ctx.rect(x1, y1, m, m);
	prev_ctx.stroke();

	canvas.setAttribute("width", m);
	canvas.setAttribute("height", m);
	canvas_ctx.drawImage(prev, x1, y1, m, m, 0, 0, m, m);

	let imageData = canvas_ctx.getImageData(0, 0, m, m);
	let scanResult = jsQR(imageData.data, m, m);

	if(scanResult) {

		let string = scanResult.data;

		qr.value = string.substring(string.length -10);

		const position = $('#qr').offset().top;
		$("html,body").animate({scrollTop:position}, 400);

		$('#alert').show();

		return false;
	}

	setTimeout(Scan, 200);
};
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking/mypage/signin/index.blade.php ENDPATH**/ ?>