<?php $__env->startSection('content'); ?>
<?php echo $__env->make('frontend.layouts.components.booking2.guest', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- section -->
<section class="mb-4">
	<div class="container">

		<ul class="row g-2">
			<li class="col">
				<a
					class="item-category-grid"
					href="<?php echo route('frontend.covid.booking2.mypage.qr.index', [
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['signin_code'],
						]); ?>"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-qrcode fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						受付QR
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="<?php echo route('frontend.covid.booking2.mypage.datetime.update'); ?>"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-pen-to-square fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						予約変更
					</div>
				</a>
			</li>
			<li class="col">
				<a
					class="item-category-grid"
					href="<?php echo route('frontend.covid.booking2.mypage.booking.destroy'); ?>"
				>
					<div class="icon-wrap mb-2">
						<i class="fa-solid fa-ban fa-fw fa-2x"></i>
					</div>
					<div class="fw-bold text text-primary">
						キャンセル
					</div>
				</a>
			</li>
		</ul>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		
		<ul
			class="nav nav-tabs nav-justified mb-3"
			role="tablist"
		>
			<li
				class="nav-item"
				role="presentation"
			>
				<button
					class="nav-link active"
					data-bs-toggle="tab"
					data-bs-target="#tab-0"
					type="button"
					role="tab"
					aria-controls="tab-0"
					aria-selected="true"
				>
					<span class="fw-bold">
						個人情報
					</span>
				</button>
			</li>
			<?php if($booking['is_form']): ?>
				<li class="nav-item" role="presentation">
					<button
						class="nav-link"
						data-bs-toggle="tab"
						data-bs-target="#tab-1"
						type="button"
						role="tab"
						aria-controls="tab-1"
						aria-selected="false"
					>
						<span class="fw-bold">
							予診票
						</span>
					</button>
				</li>
			<?php endif; ?>
		</ul>
		

		
		<div class="tab-content">
			<div
				class="tab-pane fade show active"
				id="tab-0"
				role="tabpanel"
				tabindex="0"
			>
				
				
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								氏名
							</span>
						</div>
						<div class="ms-auto">
							<?php echo implode(' ', [
								$booking['patient_sname'],
								$booking['patient_gname'],
							]); ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								氏名（かな）
							</span>
						</div>
						<div class="ms-auto">
							<?php echo implode(' ', [
								$booking['patient_skana'],
								$booking['patient_gkana'],
							]); ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								生年月日
							</span>
						</div>
						<div class="ms-auto">
							<?php echo \Carbon\Carbon::create($booking['birthday'])->isoFormat('YYYY年M月D日'); ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								性別
							</span>
						</div>
						<div class="ms-auto">
							<?php echo __("lang.dictionary.gender.{$booking['gender']}"); ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								基礎疾患あり
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['is_disease'] ? 'はい' : 'いいえ'; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								携帯電話番号
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['mobile']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								郵便番号
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['zip']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								都道府県
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['pref_label']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								市町村区
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['address1']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								町域
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['address2']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center py-3">
						<div class="">
							<span class="fw-bold">
								番地・建物名
							</span>
						</div>
						<div class="ms-auto">
							<?php echo $booking['address3']; ?>

						</div>
					</li>
				</ul>
				

			</div>

			<?php if($booking['is_form']): ?>
				<div
					class="tab-pane fade"
					id="tab-1"
					role="tabpanel"
					tabindex="0"
				>
					<ul class="list-group list-group-flush">
						<?php $__currentLoopData = $form_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<li class="list-group-item py-3">
								<dl class="mb-0">
									<dt class="mb-2">
										<?php echo $value['form_label']; ?>

									</dt>
									<dd class="mb-0">
										<ul class="list-unstyled mb-0">
											<li>
												回答 ：
												<span class="fw-normal">
													<?php echo __("lang.dictionary.is_yesno.{$value['value']}"); ?>

												</span>
											</li>
											<?php if($value['value']): ?>

												
												<?php if(isset($value['subform1'])): ?>
													<li class="mt-1">
														<?php if($value['is_input_group1']): ?>
															<?php echo $value['is_input_group1']; ?><?php echo nl2br($value['subform1_label']); ?>

														<?php else: ?>
															<?php echo nl2br($value['subform1_label']); ?> ：
															<span>
																<?php if($value['mtb_form_id'] == 12): ?>
																	<?php echo \Carbon\Carbon::parse($value['subform1'])->format('Y年n月j日'); ?>

																<?php else: ?>
																	<?php echo $value['subform1']; ?>

																<?php endif; ?>
															</span>
														<?php endif; ?>
													</li>
												<?php endif; ?>

												
												<?php if(isset($value['subform2'])): ?>
													<li class="mt-1">
														<?php echo nl2br($value['subform2_label']); ?> ：
														<span>
															<?php echo $value['subform2']; ?>

														</span>
													</li>
												<?php endif; ?>

												
												<?php if(isset($value['subform3'])): ?>
													<li class="mt-1">
														<?php echo nl2br($value['subform3_label']); ?> ：
														<span>
															<?php echo $value['subform3']; ?>

														</span>
													</li>
												<?php endif; ?>

											<?php endif; ?>
										</ul>
									</dd>
								</dl>
							</li>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</ul>
				</div>
			<?php endif; ?>
		</div>
		

	</div>
</section>
<!-- /.section -->

<?php if($booking['is_form']): ?>
	<!-- nav -->
	<br><br><br><br>
	<nav class="bar-bottom">
		<div class="d-grid gap-2 w-100">
			<a
				class="btn btn-primary btn-lg"
				href="<?php echo route('frontend.covid.booking2.pdf.create', [
					$booking['signin_code'],
				]); ?>"
				target="_blank"
			>
				<span class="fw-bold">
					予診票を確認
				</span>
			</a>
		</div>
	</nav>
	<!-- /.nav -->
<?php endif; ?>

<!-- nav -->

<!-- /.nav -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
	$(function() {
		//
	});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking2/mypage/guest/show.blade.php ENDPATH**/ ?>