<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>

<?php echo Form::hidden('yy', $yy); ?>

<?php echo Form::hidden('mm', $mm); ?>

<?php echo Form::hidden('dd', $dd); ?>


<?php echo $__env->make('backend.layouts.components.covid.booking.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<section class="mb-3">

	<!-- toolbar -->
	<div class="d-flex justify-content-center align-items-center">
		<div>
			<a
				class=""
				href="<?php echo route('admin.covid.booking.status.index', [
					$date['prev']['yy'],
					$date['prev']['mm'],
					$date['prev']['dd'],
				]); ?>"
			>
				<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
			</a>
		</div>
		<div class="mx-3">
			<span class="fs-4 fw-bold">
				<?php echo \Carbon\Carbon::create($yy, $mm, $dd)->format(__("lang.date.yymmdd")); ?>（<?php echo \Carbon\Carbon::create(
					$yy,
					$mm,
					$dd,
				)->isoFormat('ddd'); ?>）
			</span>
		</div>
		<div>
			<a
				class=""
				href="<?php echo route('admin.covid.booking.status.index', [
					$date['next']['yy'],
					$date['next']['mm'],
					$date['next']['dd'],
				]); ?>"
			>
				<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
			</a>
		</div>
	</div>
	<!-- /.toolbar -->

</section>



<section class="mb-5">

	<div class="row row-cols-1 row-cols-lg-4 g-3 mb-3">
		<div>
			<div class="card border border-secondary border-3 h-100">
				<div class="card-body py-1" style="margin-top:10px;">
					<dl class="d-flex justify-content-between align-items-center mb-0">
						<dt class="mb-0">
							ワクチン種別
						</dt>
						<dd class="text-dark mb-0">
							<span class="fw-bold fs-6">
								<?php if(isset($date['vaccine_label'])): ?>
									<?php echo $date['vaccine_label']; ?>

								<?php endif; ?>
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-primary border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-primary mb-0">
						<dt class="mb-0">
							予約枠
						</dt>
						<dd class="text-primary mb-0">
							<span class="fw-bold fs-3">
								<?php echo (is_null($count['accepted_numbers'])) ? '-' : number_format($count['accepted_numbers']); ?>

							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-success border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-success mb-0">
						<dt class="mb-0">
							確定数
						</dt>
						<dd class="text-success mb-0">
							<span class="fw-bold fs-3">
								<?php echo number_format($count['booked_numbers']); ?>

							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
		<div class="col">
			<div class="card border border-danger border-3 h-100">
				<div class="card-body py-1">
					<dl class="d-flex justify-content-between align-items-center text-danger mb-0">
						<dt class="mb-0">
							残数
						</dt>
						<dd class="mb-0">
							<span class="fw-bold fs-3">
								<?php echo number_format($count['accepted_numbers'] - $count['booked_numbers']); ?>

							</span>
							<span class="">
								名
							</span>
						</dd>
					</dl>
				</div>
			</div>
		</div>
	</div>

	<?php if($booking_list): ?>
		<!-- nav -->
		<ul class="nav nav-tabs nav-justified mb-1">
			<?php $__currentLoopData = $booking_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

				
				<?php if($hour == 0): ?>
					<li class="nav-item">
						<button
							class="nav-link py-1 active"
							data-bs-toggle="tab"
							data-bs-target="#tab<?php echo $hour; ?>"
							type="button"
							role="tab"
							aria-controls="tab<?php echo $hour; ?>"
							aria-selected="true"
						>
							<span class="fw-bold">
								全て
							</span>
						</button>
					</li>

				
				<?php else: ?>
					<li class="nav-item">
						<button
							class="nav-link py-1"
							data-bs-toggle="tab"
							data-bs-target="#tab<?php echo $hour; ?>"
							type="button"
							role="tab"
							aria-controls="tab<?php echo $hour; ?>"
							aria-selected="false"
						>
							<span class="fw-bold">
								<?php echo $hour; ?>時
							</span>
						</button>
					</li>
				<?php endif; ?>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</ul>
		<!-- /.nav -->

		<!-- tab-content -->
		<div class="tab-content">
			<?php $__currentLoopData = $booking_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<div
					class="tab-pane fade <?php echo ($hour == 0) ? 'show active' : ''; ?>"
					id="tab<?php echo $hour; ?>"
					role="tabpanel"
					tabindex="0"
				>
					<!-- toolbar -->
					<div class="d-flex justify-content-between align-items-center mt-3 mb-3">
						<div>
							件数：<span class="fw-bold"><?php echo count($content); ?></span>
						</div>
						<div>
							<div class="btn-group btn-group-sm" role="group">
								<a
									class="btn btn-outline-secondary border-secondary border-2"
									href="<?php echo route('admin.covid.export.vaccine.index', [
										$yy,
										$mm,
										$dd,
									]); ?>"
									style="margin-right: -1px;"
								>
									<span class="small fw-bold">
										<?php echo implode('', [
											'旧システム用CSV',
											__("lang.button.download"),
										]); ?>

									</span>
								</a>
								<a
									class="btn btn-outline-secondary border-secondary border-2"
									href="<?php echo route('admin.covid.export.day.index', [
										$yy,
										$mm,
										$dd,
									]); ?>"
								>
									<span class="small fw-bold">
										<?php echo implode('', [
											'予約リスト',
											__("lang.button.download"),
										]); ?>

									</span>
								</a>
							</div>
						</div>
					</div>
					<!-- /.toolbar -->

					<!-- table -->
					<table class="table">
						<colgroup>
							<col>
							<?php if($hour == 0): ?>
								<col>
							<?php endif; ?>
							<col>
							<col>
							
							<col>
							<col>
							
							<col>
							<col width="100%">
							<col>
							
							<col>
							<col>
							<col>
							<col>
						</colgroup>
						<thead>
							<tr>
								<th scope="col" nowrap>
									&nbsp;
								</th>
								<?php if($hour == 0): ?>
									<th scope="col" nowrap>
										<div class="text-center pt-1">
											<input
												type="checkbox"
												name="all_check"
												id="all"
												class="border"
											>
										</div>
									</th>
								<?php endif; ?>
								<th scope="col" nowrap>
									#
								</th>
								<th scope="col" nowrap>
									時間
								</th>
								<th scope="col" nowrap>
									受付
								</th>
								
								<th scope="col" nowrap>
									市区町村
								</th>
								
								<th scope="col" nowrap>
									
									基疾
								</th>
								<th scope="col" nowrap>
									<?php echo __("lang.booking.patient_kana"); ?>

								</th>
								<th scope="col" nowrap>
									<?php echo __("lang.booking.birthday"); ?>（<?php echo __("lang.booking.age"); ?>）
								</th>
								
								<th scope="col" nowrap>
									<?php echo __("lang.booking.mobile"); ?>

								</th>
								<th scope="col" nowrap>
									<?php echo __("lang.booking.tel"); ?>

								</th>
								<th scope="col" nowrap>
									予約受付日時
								</th>
								<th scope="col" nowrap>
									応対者
								</th>
							</tr>
						</thead>
						<tbody class="table-group-divider">
							<?php if(count($content) > 0): ?>
								<?php $__currentLoopData = $content; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td nowrap>
											<div
												class="btn-group btn-group-sm"
												role="group"
											>
												<a
													class="btn btn-outline-<?php echo (App\Helper::getIsPDF($value)) ? 'primary' : 'secondary disabled'; ?>"
													href="<?php echo route('admin.covid.booking.pdf.create', [
														$value['booking_code'],
													]); ?>"
													target="_blank"
													style="width:60px;"
												>
													<span class="small fw-bold">
														問診票
													</span>
												</a>
												<a
													class="btn btn-outline-primary"
													href="<?php echo route('admin.covid.booking.status.show', [
														$value['yy'],
														$value['mm'],
														$value['dd'],
														$value['booking_code'],
													]); ?>"
												>
													<span class="small fw-bold">
														<?php echo __("lang.button.show"); ?>

													</span>
												</a>
												<a
													class="btn btn-outline-primary"
													href="<?php echo route('admin.covid.booking.status.update', [
														$value['yy'],
														$value['mm'],
														$value['dd'],
														$value['mtb_vaccine_id'],
														$value['booking_code'],
													]); ?>"
												>
													<span class="small fw-bold">
														<?php echo __("lang.button.edit"); ?>

													</span>
												</a>
											</div>
										</td>
										<?php if($hour == 0): ?>
											<td nowrap>
												<div class="text-center pt-1">
													<?php if(App\Helper::getIsPDF($value)): ?>
														<?php echo Form::checkbox("bulk[]", $value['signin_code'], true, [
															'class' => 'bulk border',
														]); ?>

													<?php else: ?>
														<?php echo Form::checkbox('', '', false, [
															'class' => '',
															'disabled' => '',
														]); ?>

													<?php endif; ?>
												</div>
											</td>
										<?php endif; ?>
										<th scope="col" nowrap>
											<?php echo $key + 1; ?>

										</th>
										<td nowrap>
											<?php echo $value['time']; ?>

										</td>
										<td nowrap>
											<?php if($value['is_walkin']): ?>
												<span class="fw-bold text-warning">
													未予
												</span>
											<?php else: ?>
												<span class="fw-bold <?php echo ($value['is_web']) ? 'text-primary' : 'text-danger'; ?>">
													<?php echo __("lang.dictionary.is_web.{$value['is_web']}"); ?>

												</span>
											<?php endif; ?>
										</td>
										
										<td nowrap>
											<?php echo $value['address1']; ?>

										</td>
										
										<td nowrap>
											<div class="text-center text-dark">
												<?php if($value['is_disease']): ?>
													<i class="fa-solid fa-check fa-fw fa-lg"></i>
												<?php endif; ?>
											</div>
										</td>
										<td>
											<?php echo implode(' ', [
												$value['patient_skana'],
												$value['patient_gkana']
											]); ?>

										</td>
										<td nowrap>
											<?php echo \Carbon\Carbon::parse($value['birthday'])->format(__("lang.date.yymmdd")); ?>（<?php echo App\Helper::getAge(\Carbon\Carbon::parse($value['birthday'])->format('Y-m-d')); ?>）
										</td>
										
										<td nowrap>
											<?php echo $value['mobile']; ?>

										</td>
										<td nowrap>
											<?php echo $value['tel']; ?>

										</td>
										<td nowrap>
											<?php echo \Carbon\Carbon::parse($value['timestamp'])->format(__("lang.date.yymmddhhii")); ?>

										</td>
										<td nowrap>
											<?php if(!$value['is_web']): ?>
												<?php if(!is_null($value['staff_sname'])): ?>
													<?php echo implode(' ', [
														$value['staff_sname'],
														$value['staff_gname'],
													]); ?>

												<?php endif; ?>
											<?php endif; ?>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php else: ?>
								<tr>
									<td nowrap>
										<div
											class="btn-group"
											role="group"
										>
											<a
												class="btn btn-outline-secondary btn-sm disabled"
												href=""
											>
												<small class="fw-bold">
													<?php echo __("lang.button.show"); ?>

												</small>
											</a>
											<a
												class="btn btn-outline-secondary btn-sm disabled"
												href=""
											>
												<small class="fw-bold">
													<?php echo __("lang.button.edit"); ?>

												</small>
											</a>
										</div>
									</td>
									<td colspan="14">
										<div class="fw-bold text-muted text-center">
											<?php echo __("lang.error.empty"); ?>

										</div>
									</td>
								</tr>
							<?php endif; ?>
						</tbody>
					</table>
				</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</div>
		<!-- /.tab-content -->
	<?php else: ?>
		<div
			class="alert alert-secondary"
			role="alert"
		>
			<p class="text-center mb-0">
				<?php echo __("lang.error.empty"); ?>

			</p>
		</div>
	<?php endif; ?>
</section>



<div
	class="scroll-to-top"
	style="z-index:999"
>
	<?php if(!is_null($count['accepted_numbers'])): ?>
		<?php if($count['remain_numbers'] > 0): ?>
			<a
				class="btn btn-primary"
				href="<?php echo route('admin.covid.booking.status.update', [
					$yy,
					$mm,
					$dd,
					$date['mtb_vaccine_id'],
				]); ?>"
				style="width:140px;"
			>
				<span class="fw-bold">
					<?php echo __("lang.booking.create"); ?>

				</span>
			</a>
		<?php endif; ?>
	<?php endif; ?>
	<button
		class="btn btn-outline-primary"
		type="submit"
		style="width:140px;"
	>
		<span class="fw-bold">
			一括印刷
		</span>
	</button>
	<a
		class="btn btn-dark"
		href="#page-top"
	>
		<span class="fw-bold">
			<i class="fas fa-angle-up"></i>
		</span>
	</a>
</div>


<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	
	$('#all').on('click',function() {
		$('input[name="bulk[]"]').prop('checked',this.checked);
	});

	$('input[name="bulk[]"]').on('click',function(){
		if($('.bulk :checked').length == $('.bulk input').length ) {
			$('#all').prop('checked',true);
		} else {
			$('#all').prop('checked',false);
		}
	});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/booking/status/index.blade.php ENDPATH**/ ?>