<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>

<?php echo Form::hidden('booking[yy]', $yy); ?>

<?php echo Form::hidden('booking[mm]', $mm); ?>

<?php echo Form::hidden('booking[dd]', $dd); ?>

<?php echo Form::hidden('booking[hh]', $hh); ?>

<?php echo Form::hidden('booking[ii]', $ii); ?>

<?php echo Form::hidden('booking[mtb_vaccine_id]', $vaccine['mtb_vaccine_id']); ?>


<!-- section -->
<section class="mb-4">
	<div class="container">

		<?php echo $__env->make('frontend.layouts.components.progress', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				接種希望日時
			</h3>
			<hr>
			<ul class="mb-2 ps-3">
				<li>
					<span class="fw-bold">
						接種希望日と希望時間をご指定ください
					</span>
				</li>
			</ul>
			<ul class="text-danger mb-0 ps-3">
				<li>
					<span class="fw-bold">
						【印西市在住の方へ】<br>
						印西市の費用助成は2025年1月31日で終了となります。2月1日以降はご予約いただけません。
					</span>
				</li>
			</ul>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		
		<?php if($errors->any()): ?>
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					<?php echo __('lang.error.title'); ?>

				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<?php echo $error; ?>

						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
		<?php endif; ?>
		

		<div class="d-flex justify-content-center align-items-center mb-3">
			<h2>
				希望日
			</h2>
		</div>

		<!-- toolbar -->
		<div class="d-flex justify-content-center align-items-center mb-3">
			<span class="">
				<?php if($is_past): ?>
					<span
						class=""
					>
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x text-secondary"></i>
					</span>
				<?php else: ?>
					<a
						class=""
						href="<?php echo route('frontend.covid.booking2.datetime.index', [
							$date['prev']['yy'],
							$date['prev']['mm'],
						]); ?>">
						<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
					</a>
				<?php endif; ?>
			</span>
			<h2 class="mx-2">
				<?php echo \Carbon\Carbon::create($yy, $mm, 1)->format(__("lang.date.yymm")); ?>

			</h2>
			<span class="">
				<a class="" href="<?php echo route('frontend.covid.booking2.datetime.index', [$date['next']['yy'], $date['next']['mm']]); ?>">
					<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
				</a>
			</span>
		</div>
		<!-- /.toolbar -->

		<!-- toolbar -->
		<div class="mb-0">
			<div class="row g-2">

				<?php $__currentLoopData = $booking_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php if($value['remain_numbers'] > 0): ?>
						<div class="col-4">
							<a
								id="set-focus-<?php echo $i; ?>"
								class="btn btn-outline-primary w-100 px-0 <?php echo ($i == $dd) ? 'active' : ''; ?>"
								href="<?php echo route('frontend.covid.booking2.datetime.index', [
									$yy,
									$mm,
									$i,
								]); ?>"
							>
								<span class="fw-bold fs-6">
									<?php echo \Carbon\Carbon::create(
										$yy,
										$mm,
										$i,
									)->isoFormat('D日（ddd）'); ?>

								</span>
							</a>
						</div>
					<?php endif; ?>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
		</div>
		<!-- /.toolbar -->

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-0">
	<div class="container">

		<div class="d-flex justify-content-center align-items-center mb-3">
			<h2>
				希望時間
			</h2>
		</div>

		<?php if($booking_list && $time_list): ?>
			<div class="row g-2">
				<?php $__currentLoopData = $time_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<div class="col-4">
						<?php echo Form::radio('time', '', '', [
							'class' => 'btn-check',
							'id' => "time{$i}-{$key}",
							'autocomplete' => 'off',
							'onclick' => "setTime({$value['hh']}, {$value['ii']})",
						]); ?>

						<label
							
							<?php if($value['remain_number'] == 0 || $value['remain_number'] < 0 || \Carbon\Carbon::create($yy, $mm, $dd, $value['hh'], $value['ii'])->lte(\Carbon\Carbon::now())): ?>
								class="btn btn-outline-secondary w-100 disabled"
							<?php else: ?>
								class="btn btn-outline-<?php echo ($value['remain_number'] > 5) ? 'primary border border-primary' : 'warning border border-warning'; ?> border-2 w-100"
							<?php endif; ?>
							for="time<?php echo $i; ?>-<?php echo $key; ?>"
						>
							<span class="fs-5 fw-bold me-2">
								<?php echo \Carbon\Carbon::create(
									$yy,
									$mm,
									$dd,
									$value['hh'],
									$value['ii']
								)->format('H:i'); ?>

							</span>
							<br>
							<span class="fw-bold fs-4">
								<?php if($value['remain_number'] == 0 || $value['remain_number'] < 0): ?>
									×
								<?php elseif($value['remain_number'] > 5): ?>
									○
								<?php else: ?>
									△
								<?php endif; ?>
							</span>
						</label>
					</div>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
		<?php else: ?>
			<div
				class="alert alert-secondary text-center"
				role=""
			>
				<span class="fw-bold lead">
					予約できる時間帯はありません
				</span>
			</div>
		<?php endif; ?>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br><br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-primary btn-lg"
			type="submit"
			name="action"
			value="store"
		>
			<span class="fw-bold">
				<?php echo __("lang.button.next"); ?>

			</span>
		</button>
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-2"
			href="<?php echo route('frontend.covid.booking2.agreement.index'); ?>"
		>
			<span class="fw-bold">
				<?php echo __("lang.button.back"); ?>

			</span>
		</a>
	</div>
</nav>
<!-- /.nav -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	//
});

let setTime = (hh, ii) => {

	$('input:hidden[name="booking[hh]"]').val(hh);
	$('input:hidden[name="booking[ii]"]').val(ii);
};

// set focus
$(function() {
	const day = <?php echo $dd; ?>

	day && $(`#set-focus-${day}`).focus();
});

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking2/datetime/index.blade.php ENDPATH**/ ?>