<?php $__env->startSection('content'); ?>

<?php echo $__env->make('backend.layouts.components.covid.booking.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- row -->
<div class="row g-4 mb-5">

	<!-- aside -->
	<aside class="col col-lg-3">

		<div class="card mb-4">
			<ul class="list-group list-group-flush">
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							接種日
						</span>
					</div>
					<div class="">
						<span class="fw-bold fs-5">
							<?php echo $booking['yy']; ?>

						</span>
						<span class="">
							<?php echo __("lang.date.yy"); ?>

						</span>
						<span class="fw-bold fs-5">
							<?php echo $booking['mm']; ?>

						</span>
						<span class="">
							<?php echo __("lang.date.mm"); ?>

						</span>
						<span class="fw-bold fs-5">
							<?php echo $booking['dd']; ?>

						</span>
						<span class="">
							<?php echo __("lang.date.dd"); ?>

						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							予約枠
						</span>
					</div>
					<div class="text-primary">
						<span class="fw-bold fs-5">
							<?php echo $count['accepted_numbers']; ?>

						</span>
						<span class="">
							<?php echo __("lang.unit.user"); ?>

						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							確定数
						</span>
					</div>
					<div class="text-success">
						<span class="fw-bold fs-5">
							<?php echo $count['booked_numbers']; ?>

						</span>
						<span class="">
							<?php echo __("lang.unit.user"); ?>

						</span>
					</div>
				</li>
				<li class="list-group-item d-flex justify-content-between align-items-center">
					<div>
						<span class="fw-bold">
							残数
						</span>
					</div>
					<div class="text-warning">
						<span class="fw-bold fs-5">
							<?php echo $count['accepted_numbers'] - $count['booked_numbers']; ?>

						</span>
						<span class="">
							<?php echo __("lang.unit.user"); ?>

						</span>
					</div>
				</li>
			</ul>
		</div>

		<?php if($booking['is_web']): ?>
			<div class="card mb-3">
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_device"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_device']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_platform"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_platform']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_platform_version"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_platform_version']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_browser"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_browser']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_browser_version"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_browser_version']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.agent_ip"); ?>

							</span>
						</div>
						<div class="">
							<?php echo $booking['agent_ip']; ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								ロケーション
							</span>
						</div>
						<div class="">
							<?php echo implode(', ', [
								$geoip['city'],
								$geoip['state_name'],
							]); ?>

						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.is_agent_mobile"); ?>

							</span>
						</div>
						<div class="">
							<?php if($booking['is_agent_mobile']): ?>
								<?php echo __("lang.dictionary.is_yesno.1"); ?>

							<?php else: ?>
								<?php echo __("lang.dictionary.is_yesno.0"); ?>

							<?php endif; ?>
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.is_agent_tablet"); ?>

							</span>
						</div>
						<div class="">
							<?php if($booking['is_agent_tablet']): ?>
								<?php echo __("lang.dictionary.is_yesno.1"); ?>

							<?php else: ?>
								<?php echo __("lang.dictionary.is_yesno.0"); ?>

							<?php endif; ?>
						</div>
					</li>
					<li class="list-group-item d-flex justify-content-between align-items-center">
						<div class="">
							<span class="fw-bold">
								<?php echo __("lang.agent.is_agent_desktop"); ?>

							</span>
						</div>
						<div class="">
							<?php if($booking['is_agent_desktop']): ?>
								<?php echo __("lang.dictionary.is_yesno.1"); ?>

							<?php else: ?>
								<?php echo __("lang.dictionary.is_yesno.0"); ?>

							<?php endif; ?>
						</div>
					</li>
				</ul>
			</div>
		<?php endif; ?>

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

		<div class="card mb-3">
			<div class="card-body pb-2">

				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.is_web"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', __("lang.dictionary.is_web.{$booking['is_web']}"), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.master.vaccine.title"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', $booking['vaccine_label'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.is_disease"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', __("lang.dictionary.is_yesno.{$booking['is_disease']}"), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.date"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', \Carbon\Carbon::create(
							$booking['yy'],
							$booking['mm'],
							$booking['dd']
						)->isoFormat('YYYY年MM月DD日（ddd）'), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.time"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', \Carbon\Carbon::create(
							$booking['yy'],
							$booking['mm'],
							$booking['dd'],
							$booking['hh'],
							$booking['ii'],
						)->format(__("lang.date.hhii")), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				
				
				
				<?php if($booking['is_web']): ?>
					<div class="row mb-2">
						<label
							class="col-lg-2 col-form-label text-lg-end"
							for=""
						>
							<?php echo __("lang.booking.patient_name"); ?>

						</label>
						<div class="col">
							<?php echo Form::text('', implode(' ', [
								$booking['patient_sname'],
								$booking['patient_gname'],
							]), [
								'class' => 'form-control-plaintext',
								'readonly' => '',
							]); ?>

						</div>
					</div>
				<?php endif; ?>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.patient_kana"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', implode(' ', [
							$booking['patient_skana'],
							$booking['patient_gkana'],
						]), [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.birthday"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', \Carbon\Carbon::parse(
							$booking['birthday']
						)->format(__("lang.date.yymmdd")) . '（' . \App\Helper::getAge($booking['birthday']) . '歳）', [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-2">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.mobile"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', $booking['mobile'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-0">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						<?php echo __("lang.booking.tel"); ?>

					</label>
					<div class="col">
						<?php echo Form::text('', $booking['tel'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-0">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						郵便番号
					</label>
					<div class="col">
						<?php echo Form::text('', $booking['zip'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>
				<div class="row mb-0">
					<label
						class="col-lg-2 col-form-label text-lg-end"
						for=""
					>
						住所
					</label>
					<div class="col">
						<?php echo Form::text('', $booking['pref_label'] . $booking['address1'] . $booking['address2'] . $booking['address3'], [
							'class' => 'form-control-plaintext',
							'readonly' => '',
						]); ?>

					</div>
				</div>

			</div>
		</div>

	</main>
	<!-- /.main -->

</div>

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index:999"
>
	<a
		class="btn btn-primary"
		href="<?php echo route('admin.covid.booking.status.update', [
			$booking['yy'],
			$booking['mm'],
			$booking['dd'],
			$booking['mtb_vaccine_id'],
			$booking_code,
		]); ?>"
		style="width:180px;"
	>
		<span class="fw-bold">
			<?php echo __("lang.button.edit"); ?>

		</span>
	</a>
	<button
		class="btn btn-danger"
		type="button"
		data-bs-toggle="offcanvas"
		data-bs-target="#delete"
		aria-controls="delete"
		style="width:180px;"
	>
		<span class="fw-bold">
			<?php echo __("lang.button.delete"); ?>

		</span>
	</button>

	
	<a
		class="btn btn-light border border-secondary"
		href="javascript:history.back();"
		style="width:180px;"
	>
		<span class="fw-bold">
			<?php echo __("lang.button.back"); ?>

		</span>
	</a>
</div>
<!-- /.scroll-to-top -->

<!-- offcanvas -->
<div
	class="offcanvas offcanvas-bottom"
	tabindex="-1"
	id="delete"
>
	<div class="offcanvas-body text-center">
		<p class="fw-bold text-danger lead mt-3 mb-5">
			この予約を削除します。削除するとデータ復旧はできません。<br>
			本当によろしいですか？
		</p>
		<div class="d-grid gap-2 d-md-block">
			<a
				class="btn btn-danger"
				type="button"
				style="width:200px;"
				href="<?php echo route('admin.covid.booking.status.destroy', [
						$booking['yy'],
						$booking['mm'],
						$booking['dd'],
						$booking['booking_code'],
					]); ?>"
			>
				<span class="fw-bold">
					<?php echo __("lang.dictionary.is_yesno.1"); ?>

				</span>
			</a>
			<button
				class="btn btn-outline-secondary"
				type="button"
				data-bs-dismiss="offcanvas"
				aria-label="Close"
				style="width:200px;"
			>
				<span class="fw-bold">
					<?php echo __("lang.dictionary.is_yesno.0"); ?>

				</span>
			</button>
		</div>
	</div>
</div>
<!-- /.offcanvas -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	//
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/booking/status/show.blade.php ENDPATH**/ ?>