<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>

<?php echo Form::hidden('date[mtb_date_id]', $date['mtb_date_id']); ?>

<?php echo Form::hidden('date[yy]', $yy); ?>

<?php echo Form::hidden('date[mm]', $mm); ?>

<?php echo Form::hidden('date[dd]', $dd); ?>


<!-- section -->
<section class="">

	<div class="row">

		<aside class="col col-lg-2">

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					<?php echo \Carbon\Carbon::create(
						$yy,
						$mm,
						1,
					)->format(__("lang.date.yymm")); ?>

				</h5>
			</div>

			<div class="list-group">
				<?php for($i = 1; $i <= $date['day']; $i++): ?>
					<a
						class="list-group-item list-group-item-action d-flex justify-content-between align-items-center <?php echo ($i == $dd) ? 'active' : ''; ?>"
						href="<?php echo route('admin.covid.master.date.update', [
							$yy,
							$mm,
							$i,
						]); ?>"
					>
						<div>
							<span class="fw-bold">
								<?php echo implode('', [
									$i,
									__("lang.date.dd"),
								]); ?>

							</span>（<?php echo \Carbon\Carbon::create(
								$yy,
								$mm,
								$i,
							)->isoFormat('ddd'); ?>）
						</div>
						<div>
							<?php if(isset($date_list[$i])): ?>
								<span class="badge rounded-pill text-bg-primary me-1">
									設定
								</span>
							<?php endif; ?>
							<span class="">
								<i class="fa-solid fa-angle-right fa-fw"></i>
							</span>
						</div>
					</a>
				<?php endfor; ?>
			</div>

		</aside>

		<main class="col">

			<div class="d-flex justify-content-between align-items-center mb-3">
				<h5 class="text-center">
					<?php echo \Carbon\Carbon::create(
						$yy,
						$mm,
						$dd,
					)->format(__("lang.date.yymmdd")); ?>（<?php echo \Carbon\Carbon::create(
						$yy,
						$mm,
						$dd,
					)->isoFormat('ddd'); ?>）
					上限枠設定
				</h5>
			</div>

			<div class="card mb-3">
				<div class="card-body pb-0">

					<div class="input-group mb-0">
						<span
							class="input-group-text"
							style="width:100px;"
						>
							<small class="fw-bold">
								<?php echo __("lang.master.vaccine.title"); ?>

							</small>
						</span>
						<?php echo Form::select('mtb_vaccine_id', $vaccine_list, (isset($date_list[$dd])) ? $date_list[$dd]['mtb_vaccine_id'] : '', [
							'class' => 'form-select',
						]); ?>

					</div>
					<hr>

					<?php $__currentLoopData = $accepted_number_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="input-group mb-3">
							<span
								class="input-group-text"
								style="width:100px;"
							>
								<span class="fw-bold">
									<?php echo \Carbon\Carbon::create(
										$yy,
										$mm,
										$dd,
										$value['hh'],
										$value['ii'],
									)->format(__("lang.date.hhii")); ?>

								</span>
							</span>
							<?php if(is_null($date['mtb_date_id'])): ?>
								<?php echo Form::number("time[{$value['hh']}][{$value['ii']}]", (isset($time_list[$value['hh']][$value['ii']])) ? $time_list[$value['hh']][$value['ii']]['accepted_number'] : 0, [
									'class' => 'form-control',
									'id' => "time{$key}",
								]); ?>

							<?php else: ?>
								<?php echo Form::number("time[{$value['hh']}][{$value['ii']}]", (isset($time_list[$value['hh']][$value['ii']])) ? $time_list[$value['hh']][$value['ii']]['accepted_number'] : 0, [
									'class' => 'form-control',
									'id' => "time{$key}",
								]); ?>

							<?php endif; ?>
							<span class="input-group-text">
								人
							</span>
							<button
								class="btn btn-outline-secondary"
								type="button"
								onclick="resetNumber(<?php echo $key; ?>)"
							>
								<small>
									<?php echo __("lang.button.reset"); ?>

								</small>
							</button>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</div>
			</div>

		</main>

	</div>

</section>
<!-- /.section -->

<!-- scroll-to-top -->
<div
	class="scroll-to-top"
	style="z-index: 9999;"
>
	<a
		class="btn btn-light border border-secondary px-5"
		href="<?php echo route('admin.covid.master.date.index', [
			$yy,
			$mm,
			$dd,
		]); ?>"
	>
		<?php echo __("lang.button.back"); ?>

	</a>
	<button
		class="btn btn-primary px-5"
		type="submit"
		name="action"
		value="store"
	>
		<span class="fw-bold">
			<?php echo __("lang.button.submit"); ?>

		</span>
	</button>
</div>
<!-- /.scroll-to-top -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	//
});

let resetNumber = (id) => {

	$('#time' + id).val(0);
};
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/master/date/update.blade.php ENDPATH**/ ?>