<?php $__env->startSection('content'); ?>
<!-- section -->
<section class="mb-4">

	<div class="text-center mb-3">
		<img
			class="img-fluid"
			src="<?php echo implode('/', [
				asset('img'),
				'cover.png',
			]); ?>"
		>
	</div>

	<div class="container">

		<div class="text-center mb-3">
			<h2 class="lh-base mb-0" style="color:#084298;">
				医療法人社団創造会 平和台病院<br>
				コロナワクチン接種予約アプリ
			</h2>
		</div>

		

		
		<?php if($publish['is_unpublish']): ?>
			<div
				class="alert alert-danger mb-3"
				role="alert"
			>
				<h4 class="alert-heading text-center">
					【重要】予約受付終了のご連絡
				</h4>
				<hr>
				<p class="fs-6 fw-bold mb-0">
					<?php echo nl2br($publish['remark']); ?>

				</p>
			</div>

		
		<?php else: ?>
			<div
				class="alert alert-warning text-center mb-0"
				role="alert"
			>
				<p class="fs-5 fw-bold mb-0">
					コロナワクチン接種券が必要です<br>
					お手元にご用意ください
				</p>
			</div>

			
		<?php endif; ?>

	</div>
</section>
<!-- /.section -->

<?php if(!$publish['is_unpublish']): ?>
	<!-- section -->
	<section class="mb-5">
		<div class="container">

			<div class="card border-dark">
				<div class="card-body pb-2">
					<h5 class="card-title text-center mb-3">
						ご利用について
					</h5>
					<hr>
					<ul class="mb-0 ps-3">
						<li class="mb-2">
							手元に接種券がない場合は予約はできません
						</li>
						<li>
							前回接種日から３か月後の同日以降接種可能です<br>
							例）前回接種日：2023年4月1日<br>
							　　接種希望日：2023年7月1日　接種可能
						</li>
						<li class="mb-2">
							接種券に関するお問い合わせは住民票所在地の市区町村までお問い合わせください<br>
							【我孫子市民の方はこちら】<br>
							<p class="fw-bold">
								我孫子市健康づくり支援課（保健センター）新型コロナウイルスワクチン接種対策係<br>
								電話: 04-7185-1634
							</p>

						</li>
						<li class="mb-2">
							予約の変更、確認はマイページから可能です。
						</li>
						<li class="mb-2">
							お電話にてご予約いただくことも可能です。予約の変更やキャンセルもお電話で承ります。<br>
							<p class="fw-bold">
								平和台病院 新型コロナワクチン接種コールセンター<br>
								電話: 04-7189-7721
							</p>
						</li>
					</ul>
				</div>
			</div>

		</div>
	</section>
	<!-- /.section -->

	<!-- nav -->
	<br><br>
	<nav class="bar-bottom">
		<div class="d-grid gap-2 w-100">
			<a
				class="btn btn-primary btn-lg w-100"
				href="<?php echo route('frontend.covid.booking.agreement.index'); ?>"
			>
				<span class="fw-bold">
					予約にすすむ
				</span>
			</a>
			<a
				class="btn btn-outline-primary btn-lg border border-primary border-2 w-100"
				href="<?php echo route('frontend.covid.booking.mypage.signin.index'); ?>"
			>
				<span class="fw-bold">
					予約変更・キャンセル
				</span>
			</a>
		</div>
	</nav>
	<!-- /.nav -->
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	//
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.cover', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking/home/index.blade.php ENDPATH**/ ?>