<?php $__env->startSection('content'); ?>

<?php echo $__env->make('backend.layouts.components.covid.frontdesk.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		<?php echo Form::open($form); ?>

		<?php echo Form::hidden('yy', $yy); ?>

		<?php echo Form::hidden('mm', $mm); ?>

		<?php echo Form::hidden('dd', $dd); ?>


		<div class="card">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.voucher_number"); ?>

						</span>
					</label>
					<?php echo Form::text('booking[voucher_number]', (isset($booking)) ? $booking['voucher_number'] : '', [
						'class' => 'form-control alphanumeric',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							携帯電話
							
						</span>
					</label>
					<?php echo Form::tel('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							自宅電話
							
						</span>
					</label>
					<?php echo Form::tel('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]); ?>

				</div>
				
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							氏名（ひらかな）
							
						</span>
					</label>
					<div class="input-group">
						<?php echo Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
							'class' => 'form-control',
							'placeholder' => 'そうぞう',
						]); ?>

						<?php echo Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
							'class' => 'form-control',
							'placeholder' => 'いちろう',
						]); ?>

					</div>
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
					>
						<span class="fw-bold">
							<?php echo __("lang.button.search"); ?>

						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="<?php echo route('admin.covid.frontdesk.list.index', [
							$yy,
							$mm,
							$dd,
						]); ?>"
					>
						<span class="fw-bold">
							<?php echo __("lang.button.reset"); ?>

						</span>
					</a>
				</div>

			</div>
		</div>

		<?php echo Form::close(); ?>

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		<?php if(isset($booking_list)): ?>

			<!-- toolbar -->
			<div class="d-flex justify-content-between align-items-center mb-3">
				<div>
					<?php echo __("lang.form.count"); ?>：<span class="fw-bold">
						<?php echo $booking_list_count; ?>

					</span>
				</div>
				<div>

				</div>
			</div>
			<!-- /.toolbar -->

			<!-- table -->
			<div class="table-responsive">
				<table class="table">
					<colgroup>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col width="100%">
						<col>
						<col>
						<col>
					</colgroup>
					<thead>
						<tr>
							<th nowrap>
								&nbsp;
							</th>
							<th nowrap>
								#
							</th>
							<th nowrap>
								<?php echo __("lang.booking.date_booking"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.time_booking"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.time_checkedin"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.master.vaccine.title"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.voucher_number"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.patient_kana"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.birthday"); ?>（<?php echo __("lang.booking.age"); ?>）
							</th>
							<th nowrap>
								携帯電話
							</th>
							<th nowrap>
								自宅電話
							</th>
						</tr>
					</thead>
					<tbody>
						<?php if($booking_list_count > 0): ?>
							<?php $__currentLoopData = $booking_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr class="<?php echo ($value['is_checkedin']) ? 'table-primary' : ''; ?>">
									<td nowrap>
										<div class="form-check form-switch mb-0 mx-1">
											<?php echo Form::checkbox('', $value['booking_code'], $value['is_checkedin'], [
												'class' => 'form-check-input mb-0',
												'style' => 'transform: scale(1.3)',
											]); ?>

										</div>
									</td>
									<th scope="row">
										<?php echo $key + 1; ?>

									</th>
									<td nowrap>
										<?php echo \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
										)->isoFormat('YYYY年MM月DD日（ddd）'); ?>

									</td>
									<td nowrap>
										<div class="text-center">
											<?php echo \Carbon\Carbon::create(
												$value['yy'],
												$value['mm'],
												$value['dd'],
												$value['hh'],
												$value['ii'],
											)->format('H:i'); ?>

										</div>
									</td>
									<td>
										<div class="text-center">
											<?php if($value['is_checkedin']): ?>
												<span class="fw-bold text-primary">
													<?php echo \Carbon\Carbon::parse($value['timestamp_checkedin'])->format('H:i'); ?>

												</span>
											<?php endif; ?>
										</div>
									</td>
									<td nowrap>
										<?php echo $value['vaccine_label']; ?>

									</td>
									<td nowrap>
										<?php echo $value['voucher_number']; ?>

									</td>
									<td nowrap>
										<?php echo implode(' ', [
											$value['patient_skana'],
											$value['patient_gkana'],
										]); ?>

									</td>
									<td nowrap>
										<?php echo \Carbon\Carbon::parse($value['birthday'])->isoFormat('YYYY年MM月DD日'); ?>（<?php echo App\Helper::getAge($value['birthday']); ?>）
									</td>
									<td nowrap>
										<?php if(!is_null($value['mobile'])): ?>
											<?php echo $value['mobile']; ?>

										<?php endif; ?>
									</td>
									<td nowrap>
										<?php if(!is_null($value['tel'])): ?>
											<?php echo $value['tel']; ?>

										<?php endif; ?>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php else: ?>
							<tr>
								<td nowrap>
									<div class="form-check form-switch mb-0 mx-1">
										<?php echo Form::checkbox('', '', '', [
											'class' => 'form-check-input mb-0',
											'style' => 'transform: scale(1.3)',
											'disabled' => '',
										]); ?>

									</div>
								</td>
								<td colspan="11">
									<?php echo __("lang.error.empty"); ?>

								</td>
							</tr>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
			<!-- /.table -->
		<?php else: ?>

		<?php endif; ?>

	</main>
	<!-- /.main -->

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

	$('.form-check-input').change(function() {

		const id = $(this).val();
		//alert(id);return false;

		// set url
		const url = [
			'<?php echo route('ajax.ischeckedin.update'); ?>',
			id,
			(Boolean(this.checked)) ? 1 : 0
		].join('/');
		//console.log(url);return false;

		$.ajax({
			type: 'GET',
			scriptCharset: 'utf-8',
			url: url,
			dataType: 'json',
			success: function(data) {
				location.reload();
			},
			error:function(ts) {
				alert('エラーが発生しました。');
			}
		});
	});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/frontdesk/list/index.blade.php ENDPATH**/ ?>