<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>

<?php echo Form::hidden('due', $due); ?>


<!-- section -->
<section class="mb-3">
	<div class="container">

		<?php echo $__env->make('frontend.layouts.components.progress', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div
			class="alert alert-primary p-4"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				個人情報
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				予約者情報をご入力ください。<br>
				郵便番号を入力すると、都道府県市区町村が自動補完されます。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		
		<?php if($errors->any()): ?>
			<div class="alert alert-danger mb-4">
				<ul class="mb-0 ps-3">
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<?php echo $error; ?>

						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
		<?php endif; ?>
		

		<span class="p-country-name" style="display:none;">Japan</span>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					氏名
				</span>
			</label>
			<div class="input-group input-group-lg">
				<?php echo Form::text('booking[patient_sname]', (session()->get('booking.patient_sname') === null) ? '' : session()->get('booking.patient_sname'), [
					'class' => 'form-control',
					'id' => 'sname',
					'placeholder' => '例）布佐',
				]); ?>

				<?php echo Form::text('booking[patient_gname]', (session()->get('booking.patient_gname') === null) ? '' : session()->get('booking.patient_gname'), [
					'class' => 'form-control',
					'id' => 'gname',
					'placeholder' => '例）一郎',
				]); ?>

			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					氏名（ふりがな）
				</span>
			</label>
			<div class="input-group input-group-lg">
				<?php echo Form::text('booking[patient_skana]', (session()->get('booking.patient_skana') === null) ? '' : session()->get('booking.patient_skana'), [
					'class' => 'form-control',
					'id' => 'skana',
					'placeholder' => '例）ふさ',
				]); ?>

				<?php echo Form::text('booking[patient_gkana]', (session()->get('booking.patient_gkana') === null) ? '' : session()->get('booking.patient_gkana'), [
					'class' => 'form-control',
					'id' => 'gkana',
					'placeholder' => '例）いちろう',
				]); ?>

			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					生年月日
				</span>
			</label>
			<div class="input-group input-group-lg">
				<?php echo Form::select('birthday[yy]', $date_list['year_list'], (session()->get('birthday') === null) ? 1970 : session()->get('birthday.yy'), [
					'class' => 'form-select',
					'style' => 'width:30%;',
				]); ?>

				<?php echo Form::select('birthday[mm]', $date_list['month_list'], (session()->get('birthday') === null) ? '' : session()->get('birthday.mm'), [
					'class' => 'form-select',
				]); ?>

				<?php echo Form::select('birthday[dd]', $date_list['day_list'], (session()->get('birthday') === null) ? '' : session()->get('birthday.dd'), [
					'class' => 'form-select',
				]); ?>

			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					性別
				</span>
			</label>
			<div>
				<div
					class="btn-group"
					role="group"
				>
					<?php echo Form::radio('booking[gender]', 1, (session()->get('booking.gender') === null) ? true : (session()->get('booking.gender') ? true : false), [
						'class' => 'btn-check',
						'id' => 'gender-1',
						'autocomplete' => 'off',
					]); ?>

					<label
						class="btn btn-outline-primary"
						for="gender-1"
						style="width:6rem"
					>
						<span class="fw-bold">
							男性
						</span>
					</label>

					<?php echo Form::radio('booking[gender]', 0, (session()->get('booking.gender') === null) ? false : (session()->get('booking.gender') ? false : true), [
						'class' => 'btn-check',
						'id' => 'gender-0',
						'autocomplete' => 'off',
					]); ?>

					<label
						class="btn btn-outline-primary"
						for="gender-0"
						style="width:6rem"
					>
						<span class="fw-bold">
							女性
						</span>
					</label>
				</div>
			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					
					接種希望者が接種希望日において、65歳以上または60歳以上65歳未満で、心臓、腎臓もしくは呼吸器の機能またはヒト免疫不全ウイルスにより免疫の機能に障害を有する
				</span>
			</label>
			<div>
				<div
					class="btn-group"
					role="group"
				>
					<?php echo Form::radio('booking[is_disease]', 1, (session()->get('booking') === null) ? false : (session()->get('booking.is_disease') ? true : false), [
						'class' => 'btn-check',
						'id' => 'is_disease-1',
						'autocomplete' => 'off',
					]); ?>

					<label
						class="btn btn-outline-primary"
						for="is_disease-1"
						style="width:6rem"
					>
						<span class="fw-bold">
							はい
						</span>
					</label>

					<?php echo Form::radio('booking[is_disease]', 0, (session()->get('booking') === null) ? true : (session()->get('booking.is_disease') ? false : true), [
						'class' => 'btn-check',
						'id' => 'is_disease-0',
						'autocomplete' => 'off',
					]); ?>

					<label
						class="btn btn-outline-primary"
						for="is_disease-0"
						style="width:6rem"
					>
						<span class="fw-bold">
							いいえ
						</span>
					</label>
				</div>
			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					携帯電話番号（ハイフン不要）
				</span>
			</label>
			<?php echo Form::tel('booking[mobile]', (session()->get('booking.mobile') === null) ? '' : session()->get('booking.mobile'), [
				'class' => 'form-control form-control-lg',
				'placeholder' => '例）09012345678',
			]); ?>

		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					郵便番号（ハイフン不要）
				</span>
			</label>
			<div class="input-group input-group-lg">
				<?php echo Form::tel('booking[zip]', (session()->get('booking.zip') === null) ? '' : session()->get('booking.zip'), [
					'class' => 'form-control p-postal-code',
					'placeholder' => '例）2701101',
					'maxlength' => 7,
				]); ?>

			</div>
		</div>
		<div class="mb-4">
			<label
				class="form-label"
				for=""
			>
				<span class="badge rounded-pill text-bg-danger me-2">
					<?php echo __("lang.form.required"); ?>

				</span>
				<span class="fw-bold">
					住所
				</span>
			</label>
			<div class="input-group input-group-lg mb-2">
				<?php echo Form::select('booking[mtb_pref_id]', $pref_list, (session()->get('booking.mtb_pref_id') === null) ? 12 : session()->get('booking.mtb_pref_id'), [
					'class' => 'form-select p-region-id',
				]); ?>

			</div>
			<div class="input-group input-group-lg mb-2">
				<?php echo Form::text('booking[address1]', session()->get('booking.address1') ?? session()->get('booking.address1'), [
					'class' => 'form-control p-locality',
					'placeholder' => '例）我孫子市',
					// 'disabled' => '',
				]); ?>

			</div>
			<div class="input-group input-group-lg mb-2">
				<?php echo Form::text('booking[address2]', session()->get('booking.address2') ?? session()->get('booking.address2'), [
					'class' => 'form-control p-street-address',
					'placeholder' => '例）布佐',
				]); ?>

			</div>
			<div class="input-group input-group-lg">
				<?php echo Form::text('booking[address3]', session()->get('booking.address3') ?? session()->get('booking.address3'), [
					'class' => 'form-control p-extended-address',
					'placeholder' => '例）834-28',
				]); ?>

			</div>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<button
			class="btn btn-primary btn-lg w-100"
			type="submit"
			name="action"
			value="store"
			id="submit"
		>
			<span class="fw-bold">
				<?php echo __("lang.button.next"); ?>

			</span>
		</button>
		<a
			class="btn btn-outline-secondary btn-lg border border-secondary border-2"
			href="<?php echo route('frontend.covid.booking2.datetime.index'); ?>"
		>
			<span class="fw-bold">
				<?php echo __("lang.button.back"); ?>

			</span>
		</a>

		
	</div>
</nav>
<!-- /.nav -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script src="https://yubinbango.github.io/yubinbango/yubinbango.js" charset="UTF-8"></script>
<script src="<?php echo asset('vendors/autoKana/jquery.autoKana.js'); ?>"
	></script>
<script>
$(function() {
	
	$.fn.autoKana('#sname', '#skana', { katakana:false });
	$.fn.autoKana('#gname', '#gkana', { katakana:false });

	$('form').submit(function () {

		const due = $('input[name="due"]').val();
		const address1 = $('input[name="booking[address1]"]').val();

		if (due == 1 && address1 == '印西市') {
			alert("印西市の費用助成は2025年1月31日で終了となります。\n2月1日以降はご予約いただけません。");
			$('#submit').prop('disabled', true);
			return false;
		}
	});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking2/guest/index.blade.php ENDPATH**/ ?>