<?php $__env->startSection('content'); ?>
<?php echo $__env->make('backend.layouts.components.tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		<?php echo Form::open($form); ?>

		<?php echo Form::hidden('yy', $yy); ?>

		<?php echo Form::hidden('mm', $mm); ?>

		<?php echo Form::hidden('dd', $dd); ?>


		<div class="card">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.date_booking"); ?>

						</span>
					</label>
					<div class="input-group">
						<?php echo Form::select('booking[yy]', ['' => ''] + $yy_list, (isset($booking)) ? $booking['yy'] : '', [
							'class' => 'form-select',
							'style' => 'width:30%',
						]); ?>

						<?php echo Form::select('booking[mm]', ['' => ''] + $date_list['month_list'], (isset($booking)) ? $booking['mm'] : '', [
							'class' => 'form-select',
						]); ?>

						<?php echo Form::select('booking[dd]', ['' => ''] + $date_list['day_list'], (isset($booking)) ? $booking['dd'] : '', [
							'class' => 'form-select',
						]); ?>

					</div>
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.mobile"); ?>

						</span>
					</label>
					<?php echo Form::tel('booking[mobile]', (isset($booking)) ? $booking['mobile'] : '', [
						'class' => 'form-control alphanumeric',
						'autofocus' => '',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.tel"); ?>

						</span>
					</label>
					<?php echo Form::tel('booking[tel]', (isset($booking)) ? $booking['tel'] : '', [
						'class' => 'form-control alphanumeric',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.birthday"); ?>

						</span>
					</label>
					<div class="input-group">
						<?php echo Form::select('birthday[yy]', ['' => ''] + $date_list['year_list'], (isset($birthday)) ? $birthday['yy'] : '', [
							'class' => 'form-select',
							'style' => 'width:30%',
						]); ?>

						<?php echo Form::select('birthday[mm]', ['' => ''] + $date_list['month_list'], (isset($birthday)) ? $birthday['mm'] : '', [
							'class' => 'form-select',
						]); ?>

						<?php echo Form::select('birthday[dd]', ['' => ''] + $date_list['day_list'], (isset($birthday)) ? $birthday['dd'] : '', [
							'class' => 'form-select',
						]); ?>

					</div>
				</div>
				<div class="mb-3">
					<label
						class="form-label"
						for=""
					>
						<span class="fw-bold">
							<?php echo __("lang.booking.patient_kana"); ?>

						</span>
					</label>
					<div class="input-group">
						<?php echo Form::text('booking[patient_skana]', (isset($booking)) ? $booking['patient_skana'] : '', [
							'class' => 'form-control',
						]); ?>

						<?php echo Form::text('booking[patient_gkana]', (isset($booking)) ? $booking['patient_gkana'] : '', [
							'class' => 'form-control',
						]); ?>

					</div>
				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
					>
						<span class="fw-bold">
							<?php echo __("lang.button.search"); ?>

						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="<?php echo route('admin.covid.search.index', [
							$yy,
							$mm,
							$dd,
						]); ?>"
					>
						<span class="fw-bold">
							<?php echo __("lang.button.reset"); ?>

						</span>
					</a>
				</div>

			</div>
		</div>

		<?php echo Form::close(); ?>

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col col-lg-9">

		<?php if(isset($booking_list)): ?>

			<!-- toolbar -->
			<div class="d-flex justify-content-between align-items-center mb-3">
				<div>
					<?php echo __("lang.form.count"); ?>：<span class="fw-bold">
						<?php echo $booking_list_count; ?>

					</span>
				</div>
				<div>

				</div>
			</div>
			<!-- /.toolbar -->

			<!-- table -->
			<div class="table-responsive">
				<table class="table">
					<colgroup>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col>
						<col width="100%">
						<col>
						<col>
					</colgroup>
					<thead>
						<tr>
							<th nowrap>
								&nbsp;
							</th>
							<th nowrap>
								#
							</th>
							<th nowrap>
								<?php echo __("lang.booking.date_booking"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.time_booking"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.master.vaccine.title"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.voucher_number"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.patient_kana"); ?>

							</th>
							<th nowrap>
								<?php echo __("lang.booking.birthday"); ?>（<?php echo __("lang.booking.age"); ?>）
							</th>
							<th nowrap>
								連絡先
							</th>
						</tr>
					</thead>
					<tbody>
						<?php if($booking_list_count > 0): ?>
							<?php $__currentLoopData = $booking_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td nowrap>
										<div
											class="btn-group btn-group-sm"
											role="group"
										>
											<a
												class="btn btn-outline-secondary"
												href="<?php echo route('admin.covid.booking.show', [
													$value['yy'],
													$value['mm'],
													$value['dd'],
													$value['booking_code'],
												]); ?>"
											>
												<span class="fw-bold">
													<?php echo __("lang.button.show"); ?>

												</span>
											</a>
											<a
												class="btn btn-outline-secondary"
												href="<?php echo route('admin.covid.booking.update', [
													$value['yy'],
													$value['mm'],
													$value['dd'],
                                                    $value['mtb_vaccine_id'],
													$value['booking_code'],
												]); ?>"
											>
												<span class="fw-bold">
													<?php echo __("lang.button.edit"); ?>

												</span>
											</a>
										</div>
									</td>
									<th scope="row">
										<?php echo $key + 1; ?>

									</th>
									<td nowrap>
										<?php echo \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
										)->isoFormat('YYYY年MM月DD日（ddd）'); ?>

									</td>
									<td nowrap>
										<?php echo \Carbon\Carbon::create(
											$value['yy'],
											$value['mm'],
											$value['dd'],
											$value['hh'],
											$value['ii'],
										)->format('H:i'); ?>

									</td>
									<td nowrap>
										<?php echo $value['vaccine_label']; ?>

									</td>
									<td nowrap>
										<?php echo $value['voucher_number']; ?>

									</td>
									<td nowrap>
										<?php echo implode(' ', [
											$value['patient_skana'],
											$value['patient_gkana'],
										]); ?>

									</td>
									<td nowrap>
										<?php echo \Carbon\Carbon::parse($value['birthday'])->isoFormat('YYYY年MM月DD日'); ?>（<?php echo App\Helper::getAge($value['birthday']); ?>）
									</td>
									<td nowrap>
										<?php if(is_null($value['mobile'])): ?>
											<?php echo $value['tel']; ?>

										<?php else: ?>
											<?php echo $value['mobile']; ?>

										<?php endif; ?>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php else: ?>
							<tr>
								<td nowrap>
									<div
										class="btn-group btn-group-sm"
										role="group"
									>
										<a
											class="btn btn-outline-secondary disabled"
											href="#"
										>
											<span class="fw-bold">
												<?php echo __("lang.button.show"); ?>

											</span>
										</a>
										<a
											class="btn btn-outline-secondary disabled"
											href="#"
										>
											<span class="fw-bold">
												<?php echo __("lang.button.edit"); ?>

											</span>
										</a>
									</div>
								</td>
								<td colspan="7">
									<?php echo __("lang.error.empty"); ?>

								</td>
							</tr>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
			<!-- /.table -->
		<?php else: ?>

		<?php endif; ?>

	</main>
	<!-- /.main -->

</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

	$('.alphanumeric').on('input', function(e) {
		let value = $(e.currentTarget).val();
		value = value
			.replace(/[０-９]/g, function(s) {
				return String.fromCharCode(s.charCodeAt(0) - 65248);
			})
			.replace(/[^0-9]/g, '');
	  	$(e.currentTarget).val(value);
	});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/search/index.blade.php ENDPATH**/ ?>