<!DOCTYPE html>
<html lang="<?php echo str_replace('_', '-', app()->getLocale()); ?>">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="robots" content="noindex,nofollow,noarchive">
	<title><?php echo \Config::get('consts.app_name'); ?></title>

	<!-- template -->
	<link
		href="<?php echo implode('/', [
			asset('templates'),
			'dashboard',
			'css',
			'sb-admin-2.css',
		]); ?>?timestamp=<?php echo date('YmdHis'); ?>"
		rel="stylesheet"
	>

	
	
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-9ndCyUaIbzAi2FUVXJi0CjmCapSmO7SnpJef0486qhLnuZ2cdeRhO02iuK6FUUVM" crossorigin="anonymous">

	<!-- custom -->
	<link
		href="<?php echo implode('/', [
			asset('templates'),
			'dashboard',
			'css',
			'custom.css',
		]); ?>?timestamp=<?php echo date('YmdHis'); ?>"
		rel="stylesheet"
	>

	<!-- font-awesome -->
	<link
		rel="stylesheet"
		href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"
		integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw=="
		crossorigin="anonymous"
		referrerpolicy="no-referrer"
	>

	<?php echo $__env->yieldContent('css'); ?>
</head>
<body class="">
    <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

	<!-- jquery -->
	<script
		src="<?php echo implode('/', [
			asset('vendors'),
			'jquery',
			'jquery.min.js',
		]); ?>"
	></script>

	<!-- jquery -->
	<script
		src="<?php echo implode('/', [
			asset('vendors'),
			'jquery-easing',
			'jquery.easing.min.js',
		]); ?>"
	></script>

	
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
	

	<!-- custom -->
	<script
		src="<?php echo implode('/', [
			asset('templates'),
			'dashboard',
			'js',
			'sb-admin-2.js',
		]); ?>?timestamp=<?php echo date('YmdHis'); ?>"
	></script>

	<script
		src="<?php echo implode('/', [
			asset('templates'),
			'dashboard',
			'js',
			'custom.js',
		]); ?>"
	></script>

	<script>
	$(function() {
		$('form').on('keydown', 'input, button, select', function(e) {
			if(e.keyCode == 13) {
				if($(this).attr("type") == 'submit') return;

				var form = $(this).closest('form');
				var focusable = form.find('input, button[type="submit"], select, textarea')
					.not('[readonly]').filter(':visible');

				if(e.shiftKey) {
					focusable.eq(focusable.index(this) - 1).focus();
				}
				else {
					var next = focusable.eq(focusable.index(this) + 1);
					if(next.length) {
						next.focus();
					}
					else {
						focusable.eq(0).focus();
					}
				}

				e.preventDefault();
			}
		});
	});
	</script>

	<?php echo $__env->yieldContent('js'); ?>
</body>
</html>
<?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/layouts/signin.blade.php ENDPATH**/ ?>