<?php $__env->startSection('content'); ?>

<?php echo $__env->make('backend.layouts.components.covid.frontdesk.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- section -->
<section class="mb-3">

	<!-- div -->
	<div class="row justify-content-center">
		<div class="col col-lg-8">

			<?php if(isset($booking)): ?>
				<div
					class="alert alert-primary mb-4 p-5"
					role="alert"
				>
					<h3 class="alert-heading text-center">
						下記の予約者を受付処理しました
					</h3>
					<hr class="my-4">
					<dl class="row fs-4">
						<dt class="col col-lg-4 text-end mb-0">
							予約受付番号：
						</dt>
						<dd class="col mb-0">
							<span class="fw-bold" style="letter-spacing:.4em;">
								<?php echo $booking['voucher_number']; ?>

							</span>
						</dd>
					</dl>
					<dl class="row fs-4">
						<dt class="col col-lg-4 text-end mb-0">
							氏名：
						</dt>
						<dd class="col mb-0">
							<?php echo implode('', [
								$booking['patient_skana'],
								$booking['patient_gkana'],
							]); ?>

							さん
						</dd>
					</dl>
					<dl class="row fs-4 mb-0">
						<dt class="col col-lg-4 text-end mb-0">
							生年月日：
						</dt>
						<dd class="col mb-0">
							<?php echo \Carbon\Carbon::parse($booking['birthday'])->format(__("lang.date.yymmdd")); ?>

						</dd>
					</dl>
				</div>
			<?php else: ?>

				<?php if(is_null($booking_code)): ?>
					<div
						class="alert alert-danger mb-4 p-5"
						role="alert"
					>
						<h3 class="alert-heading text-center lh-base">
							この予約者は存在しません<br>
                            再読み取りしてください
						</h3>
					</div>
				<?php else: ?>
					<div
						class="alert alert-warning mb-4 p-5"
						role="alert"
					>
						<h3 class="alert-heading text-center">
							この予約者はすでに受付済みです
						</h3>
					</div>
				<?php endif; ?>
			<?php endif; ?>

			<p class="fs-4 fw-bold text-danger text-center">
				2秒後にバーコード受付画面に戻ります
			</p>

		</div>
	</div>
	<!-- /.div -->

</section>
<!-- /.section -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

    //
    setTimeout(function(){
		window.location.href = '<?php echo route('admin.covid.frontdesk.qr.index', [
			$yy,
			$mm,
			$dd,
		]); ?>';
	}, 2 * 1000);
});


</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/frontdesk/qr/show.blade.php ENDPATH**/ ?>