<?php $__env->startSection('content'); ?>
<!-- section -->
<section class="mb-0">
	<div class="container">

		<!-- toolbar -->
		<div class="d-flex justify-content-between align-items-center mb-3">
			<div class="">
				<a
					class=""
					href="<?php echo route('frontend.covid.mobile.status.index', [
						$link['prev']['yy'],
						$link['prev']['mm'],
						$link['prev']['dd'],
						$hh,
					]); ?>"
				>
					<i class="fa-solid fa-circle-chevron-left fa-fw fa-2x"></i>
				</a>
			</div>
			<div class="mx-2">
				<h2>
					<?php echo \Carbon\Carbon::create(
						$yy,
						$mm,
						$dd
					)->isoFormat('YYYY/M/D（ddd）'); ?>

				</h2>
			</div>
			<div class="">
				<a
					class=""
					href="<?php echo route('frontend.covid.mobile.status.index', [
						$link['next']['yy'],
						$link['next']['mm'],
						$link['next']['dd'],
						$hh,
					]); ?>"
				>
					<i class="fa-solid fa-circle-chevron-right fa-fw fa-2x"></i>
				</a>
			</div>
		</div>
		<!-- /.toolbar -->

		<div class="card border border-3 mb-3">
			<div class="card-body py-1">
				<div class="row row-cols-3 gx-2">
					<div class="col">
						<dl class="text-center mb-0">
							<dt class="small">
								予約総数
							</dt>
							<dd class="fw-bold text-primary mb-0">
								<span class="fs-2">
									<?php echo $booking_status_count_list[0]['booking_numbers']; ?>

								</span>
								<span class="fw-bold fs-6">
									名
								</span>
							</dd>
						</dl>
					</div>
					<div class="col">
						<dl class="text-center mb-0">
							<dt class="small">
								来院総数
							</dt>
							<dd class="text-success mb-0">
								<span class="fw-bold fs-2">
									<?php echo $booking_status_count_list[0]['checkedin_numbers']; ?>

								</span>
								<span class="fw-bold fs-6">
									名
								</span>
							</dd>
						</dl>
					</div>
					<div class="col">
						<dl class="text-center mb-0">
							<dt class="small">
								残総数
							</dt>
							<dd class="text-danger mb-0">
								<span class="fw-bold fs-2">
									<?php echo $booking_status_count_list[0]['uncheckedin_numbers']; ?>

								</span>
								<span class="fw-bold fs-6">
									名
								</span>
							</dd>
						</dl>
					</div>
				</div>
			</div>
		</div>

		<div class="input-group input-group-lg mb-2">
			
			<?php echo Form::select('hh', $time_list, $hh, [
				'class' => 'form-select',
			]); ?>

		</div>

		<div class="row row-cols-1 g-2">
			<div class="col">
				<div class="card text-primary border border-primary border-3">
					<div class="card-body py-1">
						<div class="d-flex justify-content-between align-items-center">
							<div class="fw-bold">
								予約人数
							</div>
							<div class="fw-bold fs-1">
								<?php echo $booking_status_count_list[$hh]['booking_numbers']; ?>

								<small class="fs-6">
									名
								</small>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col">
				<div class="card text-success border border-success border-3">
					<div class="card-body py-1">
						<div class="d-flex justify-content-between align-items-center">
							<div class="fw-bold">
								来院人数
							</div>
							<div class="fw-bold fs-1">
								<?php echo $booking_status_count_list[$hh]['checkedin_numbers']; ?>

								<small class="fs-6">
									名
								</small>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col">
				<div class="card text-danger border border-danger border-3">
					<div class="card-body py-1">
						<div class="d-flex justify-content-between align-items-center">
							<div class="fw-bold">
								残人数
							</div>
							<div class="fw-bold fs-1">
								<?php echo $booking_status_count_list[$hh]['uncheckedin_numbers']; ?>

								<small class="fs-6">
									名
								</small>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
        <a
            class="btn btn-outline-secondary btn-lg w-100"
            href="javascript:location.reload();"
        >
            <span class="small fw-bold">
                再読込
            </span>
        </a>
	</div>
</nav>
<!-- /.nav -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

	$('select[name="hh"]').on('change', function() {
		const id = $(this).val();
		const url = [
			'<?php echo route('frontend.covid.mobile.status.index', [
				$yy,
				$mm,
				$dd,
			]); ?>',
			id
		].join('/');

		location.href = url;0
	});
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.mobile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/mobile/status/index.blade.php ENDPATH**/ ?>