<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>


<!-- section -->
<section class="mb-4">
	<div class="container">

		<?php echo $__env->make('frontend.layouts.components.progress', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				前回接種日・今回接種回数
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				前回接種日と今回接種回数を入力してください。<br>
				前回接種日は接種券に記載されています。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-4">
	<div class="container">

		
		<?php if($errors->any()): ?>
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					<?php echo __("lang.error.title"); ?>

				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<?php echo $error; ?>

						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
		<?php endif; ?>
		

		<div class="section-title text-center mb-3">
			<h3>
				前回接種日
			</h3>
		</div>
		<div class="mb-0">
			<div class="input-group input-group-lg">
				<?php echo Form::select('date_last[yy]', $date_list['year_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.yy'), [
					'class' => 'form-select',
					'style' => 'width:30%;',
				]); ?>

				<?php echo Form::select('date_last[mm]', $date_list['month_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.mm'), [
					'class' => 'form-select',
				]); ?>

				<?php echo Form::select('date_last[dd]', $date_list['day_list'], (\Session::get('date_last') === null) ? '' : \Session::get('date_last.dd'), [
					'class' => 'form-select',
				]); ?>

			</div>
			<div class="input-group input-group-lg mb-2">

			</div>
			<div class="input-group input-group-lg">

			</div>
		</div>

	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-3">
	<div class="container">

		<div class="section-title text-center mb-3">
			<h3>
				今回接種回数
			</h3>
		</div>

		<?php for($i = $numbers['from']; $i <= $numbers['to']; $i++): ?>
			<div class="mb-2">
				<?php echo Form::radio('booking[shots_number]', $i, ((\Session::get('booking.shots_number') === null)) ? (($i == 3) ? true : false) : (($i == \Session::get('booking.shots_number')) ? true : false), [
					'class' => 'btn-check',
					'id' => "shots_number{$i}",
					'autocomplete' => 'off',
				]); ?>

				<label
					class="btn btn-outline-primary w-100"
					for="shots_number<?php echo $i; ?>"
				>
					<span class="fs-4 fw-bold">
						<?php echo $i; ?>回目
					</span>
				</label>
			</div>
		<?php endfor; ?>

	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						<?php echo __("lang.button.next"); ?>

					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					
					href="<?php echo route('frontend.covid.booking.personal.index'); ?>"
				>
					<span class="fw-bold">
						<?php echo __("lang.button.back"); ?>

					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

	//
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking/condition/index.blade.php ENDPATH**/ ?>