<?php $__env->startSection('content'); ?>
<div class="row g-4">

	<!-- aside -->
	<aside class="col-lg-3">
		<?php echo Form::open($form); ?>

		<?php echo Form::hidden("vaccine[mtb_vaccine_id]", $mtb_vaccine_id); ?>


		
		<?php if($errors->any()): ?>
			<div class="alert alert-danger mb-3">
				<ul class="mb-0 ps-3">
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<?php echo implode('', [
								$error,
								__("lang.validation.required")
							]); ?>

						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
		<?php endif; ?>
		

		<div class="card mb-3">
			<div class="card-body">

				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							<?php echo __("lang.form.required"); ?>

						</span>
						<?php echo __("lang.master.vaccine.vaccine_label"); ?>

					</label>
					<?php echo Form::text("vaccine[vaccine_label]", (isset($vaccine)) ? $vaccine["vaccine_label"] : '', [
						'class' => 'form-control',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							<?php echo __("lang.form.required"); ?>

						</span>
						<?php echo __("lang.master.vaccine.is_show"); ?>

					</label>
					<div>
						<?php for($i = 1; $i >= 0; $i--): ?>
							<div class="form-check-inline me-1">
								<?php echo Form::radio('vaccine[is_show]', $i, (isset($vaccine)) ? (($i == $vaccine['is_show']) ? true : false) : (($i == 1) ? true : false), [
									'class' => 'btn-check',
									'id' => "is_show{$i}",
									'autocomplete' => 'off',
								]); ?>

								<label
									class="btn btn-outline-primary btn-sm mb-0 px-3"
									for="is_show<?php echo $i; ?>"
									style="width:100px;"
								>
									<span class="small fw-bold">
										<?php echo __("lang.dictionary.is_yesno.{$i}"); ?>

									</span>
								</label>
							</div>
						<?php endfor; ?>
					</div>
				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<span class="badge rounded-pill text-bg-danger me-1">
							<?php echo __("lang.form.required"); ?>

						</span>
						<?php echo __("lang.form.seq"); ?>

					</label>
					<?php echo Form::number("vaccine[seq]", (isset($vaccine)) ? $vaccine['seq'] : $seq, [
						'class' => 'form-control',
					]); ?>

				</div>
				<div class="mb-3">
					<label
						class="fw-bold"
						for=""
					>
						<?php echo __("lang.form.remark"); ?>

					</label>
					<?php echo Form::textarea("vaccine[remark]", (isset($vaccine)) ? $vaccine['remark'] : '', [
						'class' => 'form-control',
						'rows' => '5',
					]); ?>

				</div>

				<div class="d-grid gap-2">
					<button
						class="btn btn-primary"
						type="submit"
						name="action"
						value="store"
					>
						<span class="small fw-bold">
							<?php echo __("lang.button.submit"); ?>

						</span>
					</button>
					<a
						class="btn btn-light border border-secondary"
						href="<?php echo route('admin.covid.master.vaccine.index'); ?>"
					>
						<span class="small fw-bold">
							<?php echo __("lang.button.cancel"); ?>

						</span>
					</a>
				</div>

			</div>
		</div>

		<?php echo Form::close(); ?>

	</aside>
	<!-- /.aside -->

	<!-- main -->
	<main class="col">

		<!-- toolbar -->
		<div class="d-flex justify-content-between align-items-center mb-3">
			<div class="">
				<?php echo __("lang.form.count"); ?>：
				<span class="fw-bold">
					<?php echo number_format($vaccine_list_count); ?>

				</span>
			</div>
			<div
				class="btn-group btn-group-sm"
				role="group"
			>
				<a
					class="btn btn-outline-secondary"
					href="<?php echo route('admin.home.index'); ?>"
				>
					<?php echo __("lang.button.home"); ?>

				</a>
				<a
					class="btn btn-outline-secondary"
					href="<?php echo route('admin.covid.master.vaccine.index'); ?>"
				>
					<?php echo __("lang.button.create"); ?>

				</a>
			</div>
		</div>
		<!-- /.toolbar -->

		<table class="table">
			<colgroup>
				<col>
				<col width="30%">
				<col>
				<col>
				<col width="70%">
			</colgroup>
			<thead>
			  <tr>
				<th scope="col" nowrap>
					&nbsp;
				</th>
				<th scope="col" nowrap>
					<?php echo __("lang.master.vaccine.vaccine_label"); ?>

				</th>
				<th scope="col" nowrap>
					<?php echo __("lang.master.vaccine.is_show"); ?>

				</th>
				<th scope="col" nowrap>
					<?php echo __("lang.form.seq"); ?>

				</th>
				<th scope="col" nowrap>
					<?php echo __("lang.form.remark"); ?>

				</th>
			  </tr>
			</thead>
			<tbody class="table-group-divider">
				<?php if($vaccine_list_count > 0): ?>
					<?php $__currentLoopData = $vaccine_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr class="<?php echo ($value["mtb_vaccine_id"] == $mtb_vaccine_id) ? 'table-primary' : ''; ?>">
							<th scope="row" nowrap>
								<div
									class="btn-group btn-group-sm"
									role="group"
								>
									<a
										class="btn <?php echo ($value["mtb_vaccine_id"] == $mtb_vaccine_id) ? 'btn-outline-primary' : 'btn-outline-secondary'; ?>"
										href="<?php echo route('admin.covid.master.vaccine.index', [
											$value["mtb_vaccine_id"]
										]); ?>"
									>
										<span class="small fw-bold">
											<?php echo __("lang.button.edit"); ?>

										</span>
									</a>
								</div>
							</th>
							<td nowrap>
								<?php echo $value["vaccine_label"]; ?>

							</td>
							<td nowrap>
								<?php if($value['is_show']): ?>
									<div class="text-center">
										<i class="fa-solid fa-check fa-fw fa-lg"></i>
									</div>
								<?php endif; ?>
							</td>
							<td nowrap>
								<div class="text-center">
									<span class="fw-bold">
										<?php echo number_format($value['seq']); ?>

									</span>
								</div>
							</td>
							<td nowrap>
								<?php echo $value['remark']; ?>

							</td>
						</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				<?php else: ?>
					<tr>
						<th scope="row" nowrap>
							<div
								class="btn-group btn-group-sm"
								role="group"
							>
								<a
									class="btn btn-outline-secondary disabled"
									href=""
								>
									<?php echo __("lang.button.edit"); ?>

								</a>
							</div>
						</th>
						<td colspan="3">
							<?php echo __("lang.error.empty"); ?>

						</td>
					</tr>
				<?php endif; ?>
			</tbody>
		</table>

	</main>
	<!-- /.main -->

</div>


<!-- section -->
<section class="">

</section>
<!-- /.section -->
<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {

	$('select').eq(0).focus();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/backend/covid/master/vaccine/index.blade.php ENDPATH**/ ?>