<?php $__env->startSection('content'); ?>
<?php echo Form::open($form); ?>


<!-- section -->
<section class="mb-4">
	<div class="container">

		<?php echo $__env->make('frontend.layouts.components.progress', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div
			class="alert alert-primary mb-0 p-3"
			role="alert"
		>
			<h3 class="alert-heading text-center mb-3">
				基礎疾患
			</h3>
			<hr>
			<p class="fw-bold mb-0">
				基礎疾患を有する方に該当するか選択してください。
			</p>
		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

		
		<?php if($errors->any()): ?>
			<div class="alert alert-danger mb-3">
				<h5 class="alert-heading text-center">
					<span class="me-0">
						<i class="fa-solid fa-triangle-exclamation fa-fw fa-lg"></i>
					</span>
					<?php echo __("lang.error.title"); ?>

				</h5>
				<hr>
				<ul class="mb-0 ps-3">
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<li>
							<?php echo $error; ?>

						</li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
		<?php endif; ?>
		

		<div
			class="alert alert-warning mb-0"
			role="alert"
		>
			<h3 class="alert-heading text-center">
				「基礎疾患を有する方」について
			</h3>
			<hr>
			<p class="mb-4">
				令和５年（2023年）度の接種における「基礎疾患を有する方」の
				範囲については、国の審議会において、現時点の科学的知見等に
				基づいて検討され、以下とすることとされています。
			</p>
			<h6 class="mb-2">
				全ての年代
			</h6>
			<ul class="mb-3 ps-3">
				<li>慢性の心臓、肝臓、腎臓又は呼吸器の病気がある方</li>
				<li>免疫の機能を低下させる病気にかかっている方</li>
				<li>免疫の機能を抑制する治療を受けている方</li>
				<li>免疫異常に伴う神経疾患又は神経筋疾患にかかっている方</li>
				<li>神経疾患又は神経疾患を原因として、身体機能が低下している方</li>
				<li>染色体に異常のある方</li>
				<li>血液の病気にかかっている方(18歳以上で、鉄欠乏性貧血にかかっている方は除く)</li>
				<li>その他、新型コロナウイルス感染症にかかった場合に重症化するおそれが大きいと医師が認める方</li>
			</ul>
			<h6 class="mb-2">
				18歳以上
			</h6>
			<ul class="mb-3 ps-3">
				<li>インスリンやその他の糖尿病治療薬で治療中又は 合併症のある糖尿病の方</li>
				<li>睡眠時無呼吸症候群の方</li>
				<li>重い精神疾患にかかっている方</li>
				<li>知的障害がある方</li>
				<li>BMI(BMI=体重(kg)/身長(m)2)が30以上の方</li>
			</ul>
			<h6 class="mb-2">
				18歳未満
			</h6>
			<ul class="mb-0 ps-3">
				<li>代謝性疾患にかかっている方</li>
				<li>悪性腫瘍がある方</li>
				<li>膠原病の方</li>
				<li>内分泌疾患にかかっている方</li>
				<li>消化器疾患にかかっている方</li>
			</ul>

		</div>
	</div>
</section>
<!-- /.section -->

<!-- section -->
<section class="mb-5">
	<div class="container">

        <div class="section-title d-flex justify-content-center align-items-center mb-3">
			<h3>
				基礎疾患を有しますか？
			</h3>
			<span class="badge rounded-pill text-bg-danger ms-1">
				<?php echo __("lang.form.required"); ?>

			</span>
		</div>
		<div class="mb-3">
			
			<div
				class="btn-group btn-group-lg d-flex"
				role="group"
			>
				<?php for($i = 1; $i >= 0; $i--): ?>
					<?php echo Form::radio('booking[is_disease]', $i, (is_null(\Session::get('booking.is_disease')) ? (($i == 0) ? false : false) : ((\Session::get('booking.is_disease') == $i) ? true : false)), [
						'class' => 'btn-check',
						'id' => "is_disease{$i}",
						'autocomplete' => 'off',
					]); ?>

					<label
						class="btn btn-outline-primary w-100"
						for="is_disease<?php echo $i; ?>"
					>
						<span class="fw-bold">
							<?php echo __("lang.dictionary.is_yesno.{$i}"); ?>

						</span>
					</label>
				<?php endfor; ?>
			</div>

		</div>
	</div>
</section>
<!-- /.section -->

<!-- nav -->
<br><br>
<nav class="bar-bottom">
	<div class="d-grid gap-2 w-100">
		<div class="d-flex">
			<div class="flex-grow-1 me-2">
				<button
					class="btn btn-primary btn-lg border border-primary border-3 w-100"
					type="submit"
					name="action"
					value="store"
				>
					<span class="fw-bold">
						<?php echo __("lang.button.next"); ?>

					</span>
				</button>
			</div>
			<div>
				<a
					class="btn btn-outline-secondary btn-lg border border-secondary border-3"
					href="<?php echo route('frontend.covid.booking.personal.index'); ?>"
				>
					<span class="fw-bold">
						<?php echo __("lang.button.back"); ?>

					</span>
				</a>
			</div>
		</div>
	</div>
</nav>
<!-- /.nav -->

<?php echo Form::close(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('css'); ?>
<style>

</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('js'); ?>
<script>
$(function() {
	//
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.sticky', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/covid/booking/disease/index.blade.php ENDPATH**/ ?>