<!DOCTYPE html>
<html lang="<?php echo str_replace('_', '-', app()->getLocale()); ?>" class="h-100">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no, shrink-to-fit=no">
	<title></title>

	<!-- favicon -->
	<link
		rel="icon"
		href="<?php echo implode('/', [
			asset('img'),
			'favicon.png',
		]); ?>"
		sizes="32x32"
		type="image/png"
	>

	
	
	<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">

	<link
		href="<?php echo implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'ui.css',
		]); ?>?timestamp=<?php echo date('YmdHis'); ?>"
		rel="stylesheet"
	>
	<link
		href="<?php echo implode('/', [
			asset('templates'),
			'mobile',
			'css',
			'custom.css',
		]); ?>?timestamp=<?php echo date('YmdHis'); ?>"
		rel="stylesheet"
	>

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />

	<?php echo $__env->yieldContent('css'); ?>
</head>

<body>

	<!-- preloader-->
	<div class="preloader" id="preloader">
		<div class="spinner-grow" role="status">
		<span class="visually-hidden">Loading...</span>
		</div>
	</div>
	<!-- /.preloader -->

	<?php echo $__env->make('frontend.layouts.components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<!-- main -->
	<main class="app-content pt-3">
		<?php echo $__env->yieldContent('content'); ?>
	</main>
	<!-- /.main -->

	<?php echo $__env->make('frontend.layouts.components.offcanvas', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<!-- jquery -->
	<script
		src="<?php echo implode('/', [
			asset('vendors'),
			'jquery',
			'jquery.min.js',
		]); ?>"
	></script>

	
	<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js" integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3" crossorigin="anonymous"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js" integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V" crossorigin="anonymous"></script>

	<!-- custom -->
	<script
		src="<?php echo implode('/', [
			asset('templates'),
			'mobile',
			'js',
			'script.js',
		]); ?>"
	></script>
	<script
		src="<?php echo implode('/', [
			asset('templates'),
			'mobile',
			'js',
			'pwa.js',
		]); ?>"
	></script>

	<script>
	$(function() {
		$('form').on('keydown', 'input, button, select', function(e) {
			if(e.keyCode == 13) {
				if($(this).attr("type") == 'submit') return;

				var form = $(this).closest('form');
				var focusable = form.find('input, button[type="submit"], select, textarea')
					.not('[readonly]').filter(':visible');

				if(e.shiftKey) {
					focusable.eq(focusable.index(this) - 1).focus();
				}
				else {
					var next = focusable.eq(focusable.index(this) + 1);
					if(next.length) {
						next.focus();
					}
					else {
						focusable.eq(0).focus();
					}
				}

				e.preventDefault();
			}
		});
	});
	</script>

	<?php echo $__env->yieldContent('js'); ?>
</body>
</html>
<?php /**PATH /var/www/sozokai-dx.com/covid/resources/views/frontend/layouts/main.blade.php ENDPATH**/ ?>